/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.gui.ContainerPlane;
import de.maxhenkel.plane.net.MessagePlaneGui;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityPlane
extends EntityPlaneSoundBase {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(EntityPlane.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EntityPlane(Level world) {
        this((EntityType<?>)((EntityType)Main.PLANE_ENTITY_TYPE.get()), world);
    }

    public EntityPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Type", this.getPlaneType().getTypeName());
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void openGUI(Player player, boolean outside) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return EntityPlane.this.getName();
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerPlane(i, EntityPlane.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.writeUUID(this.getUUID()));
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessagePlaneGui(player, outside), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPlaneType(Type.fromTypeName(compound.getString("Type")));
    }

    @Override
    public ResourceKey<LootTable> getLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"plane", (String)("entities/plane_" + this.getPlaneType().getTypeName())));
    }

    @Override
    public float getMaxFuelUsage() {
        return 15.0f;
    }

    @Override
    public int getMaxFuel() {
        return 15000;
    }

    @Override
    public double getFallSpeed() {
        return 0.1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.0)};
    }

    public Type getPlaneType() {
        return Type.values()[(Integer)this.entityData.get(TYPE)];
    }

    public void setPlaneType(Type type) {
        this.entityData.set(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak"),
        WARPED("warped"),
        CRIMSON("crimson");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getTypeName() {
            return this.name;
        }

        public static Type fromTypeName(String name) {
            for (Type type : Type.values()) {
                if (!type.getTypeName().equals(name)) continue;
                return type;
            }
            return OAK;
        }
    }
}

