/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.plane.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.plane.corelib.math.Rotation;
import de.maxhenkel.plane.entity.EntityPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3d;

public class PlaneModel
extends AbstractPlaneModel<EntityPlane> {
    private static final List<OBJModelInstance<EntityPlane>> MODELS = Arrays.asList(new OBJModelInstance<EntityPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj")), new OBJModelOptions<EntityPlane>(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png"), new Vector3d(-0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj")), new OBJModelOptions<EntityPlane>(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png"), new Vector3d(0.625, 0.125, -1.09375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-plane.getWheelRotation(partialTicks)));
    })), new OBJModelInstance<EntityPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/propeller.obj")), new OBJModelOptions<EntityPlane>(ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png"), new Vector3d(0.0, 1.0, -1.84375), (plane, matrixStack, partialTicks) -> {
        matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        matrixStack.mulPose(Axis.ZP.rotationDegrees(-plane.getPropellerRotation(partialTicks)));
    })));
    private static final List<OBJModelInstance<EntityPlane>> OAK_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/oak_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> DARK_OAK_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/dark_oak_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> BIRCH_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/birch_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> JUNGLE_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/jungle_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> ACACIA_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/acacia_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> SPRUCE_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> WARPED_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/warped_planks.png"));
    private static final List<OBJModelInstance<EntityPlane>> CRIMSON_MODEL = PlaneModel.getPlaneModel(ResourceLocation.withDefaultNamespace((String)"textures/block/crimson_planks.png"));

    public PlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.translate(0.500625, -1.25, -1.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else {
            matrixStack.translate(-0.500625, -1.25, -1.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        }
    }

    @Override
    public List<OBJModelInstance<EntityPlane>> getModels(EntityPlane entity) {
        return PlaneModel.getModelFromType(entity);
    }

    private static List<OBJModelInstance<EntityPlane>> getModelFromType(EntityPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: 
        }
        return CRIMSON_MODEL;
    }

    private static List<OBJModelInstance<EntityPlane>> getPlaneModel(ResourceLocation texture) {
        ArrayList<OBJModelInstance<EntityPlane>> models = new ArrayList<OBJModelInstance<EntityPlane>>(MODELS);
        models.add(new OBJModelInstance<EntityPlane>(new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/plane.obj")), new OBJModelOptions<EntityPlane>(texture, new Vector3d(0.0, 0.5, 0.0), new Rotation(180.0f, Axis.YP), (plane, matrixStack, partialTicks) -> matrixStack.scale(0.0625f, 0.0625f, 0.0625f))));
        return models;
    }
}

