/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.google.common.collect.ImmutableSet;
import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.FrameworkData;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.network.Network;
import com.mrcrayfish.framework.network.message.configuration.S2CSyncedEntityData;
import com.mrcrayfish.framework.network.message.play.S2CUpdateEntityData;
import com.mrcrayfish.framework.platform.Services;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class SyncedEntityData {
    private static final Marker SYNCED_ENTITY_DATA_MARKER = MarkerFactory.getMarker((String)"SYNCED_ENTITY_DATA");
    private static SyncedEntityData instance;
    private final Set<SyncedClassKey<?>> registeredClassKeys = new HashSet();
    private final Object2ObjectMap<ResourceLocation, SyncedClassKey<?>> idToClassKey = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, SyncedClassKey<?>> classNameToClassKey = new Object2ObjectOpenHashMap();
    private final Map<String, Boolean> clientClassNameCapabilityCache = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Boolean> serverClassNameCapabilityCache = new ConcurrentHashMap<String, Boolean>();
    private final Set<SyncedDataKey<?, ?>> registeredDataKeys = new HashSet();
    private final Reference2ObjectMap<SyncedClassKey<?>, HashMap<ResourceLocation, SyncedDataKey<?, ?>>> classToKeys = new Reference2ObjectOpenHashMap();
    private final Reference2IntMap<SyncedDataKey<?, ?>> internalIds = new Reference2IntOpenHashMap();
    private final Int2ReferenceMap<SyncedDataKey<?, ?>> syncedIdToKey = new Int2ReferenceOpenHashMap();
    private final AtomicInteger nextIdTracker = new AtomicInteger();
    private final Set<Entity> dirtyEntities = new HashSet<Entity>();
    private boolean dirty = false;

    private SyncedEntityData() {
        PlayerEvents.START_TRACKING_ENTITY.register(this::onStartTracking);
        EntityEvents.JOIN_LEVEL.register(this::onEntityJoinWorld);
        TickEvents.END_SERVER.register(this::onServerTickEnd);
        PlayerEvents.COPY.register(this::onPlayerClone);
    }

    public static SyncedEntityData instance() {
        if (instance == null) {
            instance = new SyncedEntityData();
        }
        return instance;
    }

    private <E extends Entity> void registerClassKey(SyncedClassKey<E> classKey) {
        if (!this.registeredClassKeys.contains(classKey)) {
            this.registeredClassKeys.add(classKey);
            this.idToClassKey.put((Object)classKey.id(), classKey);
            this.classNameToClassKey.put((Object)classKey.entityClass().getName(), classKey);
        }
    }

    public synchronized <E extends Entity, T> void registerDataKey(SyncedDataKey<E, T> dataKey) {
        ResourceLocation keyId = dataKey.id();
        SyncedClassKey<E> classKey = dataKey.classKey();
        if (FrameworkData.isLoaded()) {
            throw new IllegalStateException(String.format("Tried to register synced data key %s for %s after game initialization", keyId, classKey.id()));
        }
        if (this.registeredDataKeys.contains(dataKey)) {
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is already registered", keyId, classKey.id()));
        }
        this.registerClassKey(dataKey.classKey());
        this.registeredDataKeys.add(dataKey);
        ((HashMap)this.classToKeys.computeIfAbsent(classKey, c -> new HashMap())).put(keyId, dataKey);
        int nextId = this.nextIdTracker.getAndIncrement();
        this.internalIds.put(dataKey, nextId);
        this.syncedIdToKey.put(nextId, dataKey);
        Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Registered synced data key {} for {}", (Object)dataKey.id(), (Object)classKey.id());
    }

    public <E extends Entity, T> void set(E entity, SyncedDataKey<?, ?> key, T value) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        if (holder != null && holder.set(entity, key, value) && !entity.level().isClientSide()) {
            this.dirty = true;
            this.dirtyEntities.add(entity);
        }
    }

    public <E extends Entity, T> T get(E entity, SyncedDataKey<E, T> key) {
        if (!this.registeredDataKeys.contains(key)) {
            String keys = this.registeredDataKeys.stream().map(k -> k.pairKey().toString()).collect(Collectors.joining(",", "[", "]"));
            Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Registered keys before throwing exception: {}", (Object)keys);
            throw new IllegalArgumentException(String.format("The synced data key %s for %s is not registered!", key.id(), key.classKey().id()));
        }
        DataHolder holder = this.getDataHolder(entity);
        return holder != null ? holder.get(key) : key.defaultValueSupplier().get();
    }

    public <E extends Entity, T> void updateClientEntry(Entity entity, DataEntry<E, T> entry) {
        SyncedEntityData.instance().set(entity, entry.getKey(), entry.getValue());
    }

    public int getInternalId(SyncedDataKey<?, ?> key) {
        return this.internalIds.getInt(key);
    }

    SyncedClassKey<?> getClassKey(ResourceLocation id) {
        return (SyncedClassKey)this.idToClassKey.get((Object)id);
    }

    Map<ResourceLocation, SyncedDataKey<?, ?>> getDataKeys(SyncedClassKey<?> key) {
        return (Map)this.classToKeys.get(key);
    }

    @Nullable
    SyncedDataKey<?, ?> getKey(int id) {
        return (SyncedDataKey)this.syncedIdToKey.get(id);
    }

    public Set<SyncedDataKey<?, ?>> getKeys() {
        return ImmutableSet.copyOf(this.registeredDataKeys);
    }

    @Nullable
    private DataHolder getDataHolder(Entity entity) {
        return Services.ENTITY.getDataHolder(entity, false);
    }

    public boolean hasSyncedDataKey(Entity entity) {
        Class<?> entityClass = entity.getClass();
        return this.getClassNameCapabilityCache(entity.level().isClientSide).computeIfAbsent(entityClass.getName(), c -> {
            Class targetClass = entityClass;
            while (!targetClass.isAssignableFrom(Entity.class)) {
                if (this.classNameToClassKey.containsKey((Object)targetClass.getName())) {
                    return true;
                }
                targetClass = targetClass.getSuperclass();
            }
            return false;
        });
    }

    private Map<String, Boolean> getClassNameCapabilityCache(boolean client) {
        return client ? this.clientClassNameCapabilityCache : this.serverClassNameCapabilityCache;
    }

    private void onStartTracking(Entity target, Player player) {
        DataHolder holder;
        if (!player.level().isClientSide() && this.hasSyncedDataKey(target) && (holder = this.getDataHolder(target)) != null) {
            List<DataEntry<?, ?>> entries = holder.gatherAll();
            entries.removeIf(entry -> !entry.getKey().syncMode().isTracking());
            if (!entries.isEmpty()) {
                Network.getPlayChannel().sendToPlayer(() -> (ServerPlayer)player, new S2CUpdateEntityData(target.getId(), entries));
            }
        }
    }

    private void onEntityJoinWorld(Entity entity, Level level, boolean disk) {
        if (entity instanceof Player) {
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            Player player = (Player)entity;
            if (!level.isClientSide() && this.hasSyncedDataKey((Entity)player) && (holder = this.getDataHolder((Entity)player)) != null && !(entries = holder.gatherAll()).isEmpty()) {
                Network.getPlayChannel().sendToPlayer(() -> (ServerPlayer)player, new S2CUpdateEntityData(player.getId(), entries));
            }
        }
    }

    private void onPlayerClone(Player oldPlayer, Player newPlayer, boolean respawn) {
        if (!this.hasSyncedDataKey((Entity)newPlayer)) {
            return;
        }
        DataHolder oldHolder = Services.ENTITY.getDataHolder((Entity)oldPlayer, true);
        if (oldHolder == null) {
            return;
        }
        DataHolder newHolder = this.getDataHolder((Entity)newPlayer);
        if (newHolder == null) {
            return;
        }
        RegistryAccess access = newPlayer.registryAccess();
        HashMap dataMap = new HashMap();
        oldHolder.dataMap.forEach((key, entry) -> {
            if (respawn || key.persistent()) {
                DataEntry newEntry = new DataEntry(newHolder, key);
                newEntry.readValue(entry.writeValue((HolderLookup.Provider)access), (HolderLookup.Provider)access);
                dataMap.put((SyncedDataKey<?, ?>)key, newEntry);
            }
        });
        newHolder.dataMap = dataMap;
    }

    private void onServerTickEnd(MinecraftServer server) {
        if (!this.dirty) {
            return;
        }
        if (this.dirtyEntities.isEmpty()) {
            this.dirty = false;
            return;
        }
        for (Entity entity : this.dirtyEntities) {
            List<DataEntry<?, ?>> trackingEntries;
            List<DataEntry<?, ?>> entries;
            DataHolder holder = this.getDataHolder(entity);
            if (holder == null || !holder.isDirty() || (entries = holder.gatherDirty()).isEmpty()) continue;
            List<DataEntry<?, ?>> selfEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isSelf()).collect(Collectors.toList());
            if (!selfEntries.isEmpty() && entity instanceof ServerPlayer) {
                Network.getPlayChannel().sendToPlayer(() -> (ServerPlayer)entity, new S2CUpdateEntityData(entity.getId(), selfEntries));
            }
            if (!(trackingEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isTracking()).collect(Collectors.toList())).isEmpty()) {
                Network.getPlayChannel().sendToTrackingEntity(() -> entity, new S2CUpdateEntityData(entity.getId(), trackingEntries));
            }
            holder.clean();
        }
        this.dirtyEntities.clear();
        this.dirty = false;
    }

    public boolean updateMappings(S2CSyncedEntityData message) {
        this.syncedIdToKey.clear();
        ArrayList missingKeys = new ArrayList();
        message.getKeyMap().forEach((classId, list) -> {
            SyncedClassKey classKey = (SyncedClassKey)this.idToClassKey.get(classId);
            if (classKey == null || !this.classToKeys.containsKey((Object)classKey)) {
                list.forEach(pair -> missingKeys.add(Pair.of((Object)classId, (Object)((ResourceLocation)pair.getLeft()))));
                return;
            }
            Map keys = (Map)this.classToKeys.get((Object)classKey);
            list.forEach(pair -> {
                SyncedDataKey syncedDataKey = (SyncedDataKey)keys.get(pair.getLeft());
                if (syncedDataKey == null) {
                    missingKeys.add(Pair.of((Object)classId, (Object)((ResourceLocation)pair.getLeft())));
                    return;
                }
                this.syncedIdToKey.put(((Integer)pair.getRight()).intValue(), (Object)syncedDataKey);
            });
        });
        if (!missingKeys.isEmpty()) {
            String keys = missingKeys.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
            Constants.LOG.info(SYNCED_ENTITY_DATA_MARKER, "Received unknown synced keys: {}", (Object)keys);
        }
        return missingKeys.isEmpty();
    }

    public List<S2CSyncedEntityData> getConfigurationMessages() {
        HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>> map = new HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>>();
        this.getKeys().forEach(key -> {
            int id = this.getInternalId((SyncedDataKey<?, ?>)key);
            map.computeIfAbsent(key.classKey().id(), c -> new ArrayList()).add(Pair.of((Object)key.id(), (Object)id));
        });
        return List.of(new S2CSyncedEntityData(map));
    }

    void markDirty(Entity entity) {
        this.dirty = true;
        this.dirtyEntities.add(entity);
    }
}

