/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.sound;

import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class SoundLoopPlane
extends AbstractTickableSoundInstance {
    protected EntityPlaneSoundBase plane;

    public SoundLoopPlane(EntityPlaneSoundBase plane, SoundEvent event, SoundSource category) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.plane = plane;
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.relative = false;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.updatePos();
    }

    public void updatePos() {
        this.x = (float)this.plane.getX();
        this.y = (float)this.plane.getY();
        this.z = (float)this.plane.getZ();
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        if (!this.plane.isAlive()) {
            this.stop();
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isAlive()) {
            this.stop();
            return;
        }
        if (this.shouldStopSound()) {
            this.stop();
            return;
        }
        this.updatePos();
    }

    public abstract boolean shouldStopSound();
}

