/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.config;

import java.util.function.Supplier;
import mezz.jei.common.config.IServerConfig;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class ServerConfig
implements IServerConfig {
    private final Supplier<Boolean> enableCheatModeForOp;
    private final Supplier<Boolean> enableCheatModeForCreative;
    private final Supplier<Boolean> enableCheatModeForGive;

    public static IServerConfig register(ModLoadingContext modLoadingContext) {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        ServerConfig instance = new ServerConfig(builder);
        ModConfigSpec config = builder.build();
        ModContainer activeContainer = modLoadingContext.getActiveContainer();
        activeContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)config);
        return instance;
    }

    private ServerConfig(ModConfigSpec.Builder builder) {
        builder.push("cheat mode");
        builder.comment("Enable Cheat Mode for Operators (/op)");
        this.enableCheatModeForOp = builder.define("enableCheatModeForOp", true);
        builder.comment("Enable Cheat Mode for users in Creative Mode");
        this.enableCheatModeForCreative = builder.define("enableCheatModeForCreative", true);
        builder.comment("Enable Cheat Mode for users who can use /give");
        this.enableCheatModeForGive = builder.define("enableCheatModeForGive", false);
        builder.pop();
    }

    @Override
    public boolean isCheatModeEnabledForOp() {
        return this.enableCheatModeForOp.get();
    }

    @Override
    public boolean isCheatModeEnabledForCreative() {
        return this.enableCheatModeForCreative.get();
    }

    @Override
    public boolean isCheatModeEnabledForGive() {
        return this.enableCheatModeForGive.get();
    }
}

