/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.DamageSourcePlane;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneInventoryBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlaneDamageBase
extends EntityPlaneBase {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(EntityPlaneDamageBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();

    public EntityPlaneDamageBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        Runnable task;
        super.tick();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        if (this.isInLava()) {
            this.setPlaneDamage(this.getPlaneDamage() + 1.0f);
        }
        this.handleParticles();
    }

    protected void handleParticles() {
        if (!this.level().isClientSide) {
            return;
        }
        if (!((EntityPlaneSoundBase)this).isStarted()) {
            return;
        }
        float damage = this.getPlaneDamage();
        float chance = Math.max(damage - 25.0f, 0.0f) / 100.0f;
        if (this.random.nextFloat() < chance) {
            Vec3 lookVec = this.getLookAngle().normalize().scale(1.5);
            this.spawnParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, lookVec.x, lookVec.y, lookVec.z);
        }
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double rand) {
        this.level().addParticle(particleTypes, this.getX() + offX + (this.random.nextDouble() * rand - rand / 2.0), this.getY() + (double)this.getBbHeight() / 2.0 + offY + (this.random.nextDouble() * rand - rand / 2.0), this.getZ() + offZ + (this.random.nextDouble() * rand - rand / 2.0), 0.0, 0.0, 0.0);
    }

    private void spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ) {
        this.spawnParticle(particleTypes, offX, offY, offZ, 1.0);
    }

    @Override
    public void damagePlane(double damage, boolean horizontal) {
        super.damagePlane(damage, horizontal);
        this.setPlaneDamage((float)((double)this.getPlaneDamage() + damage));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerable()) {
            return false;
        }
        if (this.level().isClientSide || !this.isAlive()) {
            return false;
        }
        if (!(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)source.getDirectEntity();
        if (player == null) {
            return false;
        }
        if (this.hasPassenger((Entity)player)) {
            return false;
        }
        if (player.getAbilities().instabuild && player.isShiftKeyDown()) {
            this.destroyPlane(source, player);
            return true;
        }
        ItemStack heldItem = player.getMainHandItem();
        if (heldItem.getItem().equals(ModItems.WRENCH.get()) && heldItem.getMaxDamage() - heldItem.getDamageValue() >= 512) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                heldItem.hurtAndBreak(512, serverPlayer.serverLevel(), serverPlayer, item -> {});
            }
            this.destroyPlane(source, player);
        }
        return false;
    }

    public void destroyPlane(DamageSource source, Player player) {
        Container inventory = ((EntityPlaneInventoryBase)this).getInventory();
        Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), (Container)inventory);
        inventory.clearContent();
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(this.getLootTable());
        LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player);
        loottable.getRandomItems(context.create(LootContextParamSets.ENTITY)).forEach(arg_0 -> ((EntityPlaneDamageBase)this).spawnAtLocation(arg_0));
        this.kill();
    }

    public abstract ResourceKey<LootTable> getLootTable();

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public float getPlaneDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setPlaneDamage(float damage) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damage));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        double speed;
        if (!this.level().isClientSide && entity instanceof LivingEntity && !this.getPassengers().contains(entity) && entity.getBoundingBox().intersects(this.getBoundingBox()) && (speed = this.getDeltaMovement().length()) > (double)0.35f) {
            float damage = Math.min((float)(speed * 10.0), 15.0f);
            this.tasks.add(() -> {
                ServerLevel serverLevel = (ServerLevel)this.level();
                Optional holder = serverLevel.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DamageSourcePlane.DAMAGE_PLANE_TYPE);
                holder.ifPresent(damageTypeReference -> entity.hurt(new DamageSource((Holder)damageTypeReference, (Entity)this), damage));
            });
        }
        return super.canCollideWith(entity);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPlaneDamage(compound.getFloat("Damage"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Damage", this.getPlaneDamage());
    }
}

