/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.corelib.item.ItemUtils;
import de.maxhenkel.plane.entity.EntityPlaneFuelBase;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class EntityPlaneInventoryBase
extends EntityPlaneFuelBase {
    private Container inventory = new SimpleContainer(27);

    public EntityPlaneInventoryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide) {
                this.openGUI(player, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public abstract void openGUI(Player var1, boolean var2);

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ItemUtils.readInventory((HolderLookup.Provider)this.registryAccess(), compound, "Inventory", this.inventory);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ItemUtils.saveInventory((HolderLookup.Provider)this.registryAccess(), compound, "Inventory", this.inventory);
    }
}

