/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import de.maxhenkel.plane.ClientConfig;
import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final ResourceLocation PLANE_INFO_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/gui/plane_info.png");
    private Minecraft mc = Minecraft.getInstance();
    private EntityPlaneSoundBase lastVehicle;
    private double cachedRelativeHeight = 0.0;

    @SubscribeEvent
    public void onRender(ViewportEvent.ComputeCameraAngles evt) {
        if (this.getPlane() != null && !this.mc.options.getCameraType().isFirstPerson()) {
            evt.getCamera().move(-evt.getCamera().getMaxZoom(((Double)Main.CLIENT_CONFIG.planeZoom.get()).floatValue() - 4.0f), 0.0f, 0.0f);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollingEvent evt) {
        if (this.getPlane() != null && !this.mc.options.getCameraType().isFirstPerson()) {
            Main.CLIENT_CONFIG.planeZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.planeZoom.get() - evt.getScrollDeltaY())));
            Main.CLIENT_CONFIG.planeZoom.save();
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRender(RenderGuiLayerEvent.Post evt) {
        if (!VanillaGuiLayers.HOTBAR.equals((Object)evt.getName())) {
            return;
        }
        LocalPlayer player = this.mc.player;
        Entity e = player.getVehicle();
        if (!(e instanceof EntityPlaneSoundBase)) {
            return;
        }
        EntityPlaneSoundBase plane = (EntityPlaneSoundBase)e;
        if (((Boolean)Main.CLIENT_CONFIG.showPlaneInfo.get()).booleanValue()) {
            this.renderPlaneInfo(evt.getGuiGraphics(), plane);
        }
    }

    public void renderPlaneInfo(GuiGraphics guiGraphics, EntityPlaneSoundBase plane) {
        guiGraphics.pose().pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int texWidth = 110;
        int texHeight = 90;
        int height = this.mc.getWindow().getGuiScaledHeight();
        int width = this.mc.getWindow().getGuiScaledWidth();
        float scale = ((Double)Main.CLIENT_CONFIG.planeInfoScale.get()).floatValue();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate((double)(-width), (double)(-height), 0.0);
        guiGraphics.pose().translate((double)width * (1.0 / (double)scale), (double)height * (1.0 / (double)scale), 0.0);
        int padding = 3;
        int yStart = height - texHeight - padding;
        int xStart = width - texWidth - padding;
        guiGraphics.blit(PLANE_INFO_TEXTURE, xStart, yStart, 0, 0, texWidth, texHeight);
        Font font = this.mc.gui.getFont();
        Function<Integer, Integer> heightFunc = integer -> {
            Objects.requireNonNull(font);
            return yStart + 8 + (9 + 2) * integer;
        };
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.getDeltaMovement().length())}).getVisualOrderText(), xStart + 7, heightFunc.apply(0).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.vertical_speed", (Object[])new Object[]{((ClientConfig.SpeedType)((Object)Main.CLIENT_CONFIG.planeInfoSpeedType.get())).getTextComponent(plane.getDeltaMovement().y())}).getVisualOrderText(), xStart + 7, heightFunc.apply(1).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.throttle", (Object[])new Object[]{String.valueOf(Math.round(plane.getEngineSpeed() * 100.0f))}).getVisualOrderText(), xStart + 7, heightFunc.apply(2).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.height", (Object[])new Object[]{String.valueOf(Math.round(plane.getY()))}).getVisualOrderText(), xStart + 7, heightFunc.apply(3).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.relative_height", (Object[])new Object[]{String.valueOf(Math.round(this.cachedRelativeHeight))}).getVisualOrderText(), xStart + 7, heightFunc.apply(4).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{String.valueOf(plane.getFuel())}).getVisualOrderText(), xStart + 7, heightFunc.apply(5).intValue(), 0, false);
        guiGraphics.drawString(font, Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{String.valueOf(MathUtils.round(plane.getPlaneDamage(), 2))}).getVisualOrderText(), xStart + 7, heightFunc.apply(6).intValue(), 0, false);
        guiGraphics.pose().popPose();
    }

    private double getRelativeHeight(EntityPlaneSoundBase plane) {
        int highestBlock = (int)plane.getY();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos(plane.getX(), plane.getY(), plane.getZ());
        for (int y = highestBlock; y >= plane.level().getMinBuildHeight(); --y) {
            p.setY(y);
            if (!plane.level().getBlockState((BlockPos)p).canOcclude()) continue;
            highestBlock = y;
            break;
        }
        return plane.getY() - (double)(highestBlock + 1);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player.getVehicle() instanceof EntityPlaneSoundBase) {
            EntityPlaneSoundBase plane = (EntityPlaneSoundBase)event.getEntity().getVehicle();
            event.getPoseStack().pushPose();
            event.getPoseStack().mulPose(Axis.YP.rotationDegrees(-(plane.yRotO + (plane.getYRot() - plane.yRotO) * event.getPartialTick())));
            event.getPoseStack().mulPose(Axis.XP.rotationDegrees(plane.xRotO + (plane.getXRot() - plane.xRotO) * event.getPartialTick()));
            List passengers = plane.getPassengers();
            int i = passengers.indexOf(player);
            if (i >= 0) {
                Vec3 offset = plane.getPlayerOffsets()[i];
                offset = offset.xRot((float)(-Math.toRadians(plane.getXRot())));
                event.getPoseStack().translate(0.0, offset.y, 0.0);
            }
            event.getPoseStack().scale(plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor(), plane.getPlayerScaleFactor());
            event.getPoseStack().translate(0.0f, (player.getBbHeight() - player.getBbHeight() * plane.getPlayerScaleFactor()) / 1.5f + (float)plane.getPlayerOffsets()[0].y, 0.0f);
            event.getPoseStack().mulPose(Axis.YP.rotationDegrees(plane.yRotO + (plane.getYRot() - plane.yRotO) * event.getPartialTick()));
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (event.getEntity().getVehicle() instanceof EntityPlaneSoundBase) {
            event.getPoseStack().popPose();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre evt) {
        if (!evt.getEntity().equals((Object)this.mc.player)) {
            return;
        }
        EntityPlaneSoundBase vehicle = this.getPlane();
        if (vehicle != null && evt.getEntity().equals((Object)vehicle.getDriver())) {
            this.cachedRelativeHeight = this.getRelativeHeight(vehicle);
        }
        if (vehicle != null && this.lastVehicle == null) {
            this.mc.options.setCameraType(CameraType.THIRD_PERSON_BACK);
        } else if (vehicle == null && this.lastVehicle != null) {
            this.mc.options.setCameraType(CameraType.FIRST_PERSON);
        }
        this.lastVehicle = vehicle;
    }

    private EntityPlaneSoundBase getPlane() {
        if (this.mc.player.getVehicle() instanceof EntityPlaneSoundBase) {
            return (EntityPlaneSoundBase)this.mc.player.getVehicle();
        }
        return null;
    }
}

