/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.item;

import de.maxhenkel.plane.corelib.math.MathUtils;
import de.maxhenkel.plane.entity.EntityPlaneFuelBase;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import de.maxhenkel.plane.item.ModItems;
import de.maxhenkel.plane.item.PlaneData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ItemAbstractPlane<T extends EntityPlaneSoundBase>
extends Item {
    public ItemAbstractPlane() {
        super(new Item.Properties().stacksTo(1));
    }

    public abstract T createPlane(Level var1);

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        if (!context.getClickedFace().equals((Object)Direction.UP)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        if (!world.getBlockState((pos = context.getClickedPos()).above()).getCollisionShape((BlockGetter)world, pos).isEmpty()) {
            return InteractionResult.FAIL;
        }
        Player player = context.getPlayer();
        T plane = this.createPlane(world);
        ((EntityPlaneFuelBase)((Object)plane)).setFuel(500);
        BlockState state = world.getBlockState(pos);
        VoxelShape collisionShape = state.getCollisionShape((BlockGetter)world, pos);
        plane.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY() + (collisionShape.isEmpty() ? 0.0 : state.getCollisionShape((BlockGetter)world, (BlockPos)pos).bounds().maxY) + 0.01, (double)pos.getZ() + 0.5, context.getPlayer().getYRot(), 0.0f);
        this.addData(context.getItemInHand(), (EntityPlaneSoundBase)((Object)plane));
        world.addFreshEntity(plane);
        if (!player.getAbilities().instabuild) {
            context.getItemInHand().setCount(context.getItemInHand().getCount() - 1);
        }
        return InteractionResult.SUCCESS;
    }

    private void addData(ItemStack stack, EntityPlaneSoundBase plane) {
        Component customName;
        ItemAbstractPlane.convert(stack);
        PlaneData planeData = (PlaneData)stack.get(ModItems.PLANE_DATA_COMPONENT);
        if (planeData != null) {
            plane.readAdditionalSaveData(planeData.getPlaneData());
            plane.setStarted(false, false);
        }
        if ((customName = (Component)stack.get(DataComponents.CUSTOM_NAME)) != null) {
            plane.setCustomName(customName);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flagIn) {
        ItemAbstractPlane.convert(stack);
        PlaneData planeData = (PlaneData)stack.get(ModItems.PLANE_DATA_COMPONENT);
        if (planeData != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.plane.damage", (Object[])new Object[]{Component.literal((String)String.valueOf(MathUtils.round(planeData.getDamage(), 2))).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.plane.fuel", (Object[])new Object[]{Component.literal((String)String.valueOf(planeData.getFuel())).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }

    public static void convert(ItemStack stack) {
        if (!(stack.getItem() instanceof ItemAbstractPlane)) {
            return;
        }
        if (stack.has(ModItems.PLANE_DATA_COMPONENT)) {
            return;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return;
        }
        CompoundTag compoundTag = customData.copyTag();
        if (!compoundTag.contains("PlaneData", 10)) {
            return;
        }
        CompoundTag planeData = compoundTag.getCompound("PlaneData");
        compoundTag.remove("PlaneData");
        if (compoundTag.isEmpty()) {
            stack.remove(DataComponents.CUSTOM_DATA);
        } else {
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
        }
        PlaneData data = PlaneData.of(planeData);
        stack.set(ModItems.PLANE_DATA_COMPONENT, (Object)data);
    }
}

