/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.WorkbenchBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WorkbenchBlockEntity
extends ElectricityModuleLootBlockEntity
implements IWorkbench {
    public static final int DATA_POWERED = 0;
    public static final int RESULT_SLOT = 12;
    @Nullable
    protected Player currentUser;
    protected int updateTimer;
    protected int countsHash;
    protected final DataSlot selectedRecipe = DataSlot.standalone();
    protected final DataSlot searchNeighbours = DataSlot.standalone();
    protected final ContainerData data = new BuildableContainerData(builder -> builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {}));

    public WorkbenchBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.WORKBENCH.get(), pos, state);
    }

    public WorkbenchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 13);
        this.selectedRecipe.set(-1);
        this.searchNeighbours.set(1);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        return menu instanceof WorkbenchMenu;
    }

    protected Component getDefaultName() {
        return Utils.translation("container", "workbench", new Object[0]);
    }

    protected AbstractContainerMenu createMenu(int windowId, Inventory playerInventory) {
        return new WorkbenchMenu(windowId, playerInventory, this, this.data);
    }

    public WorkbenchMenu.CustomData createSyncData() {
        return new WorkbenchMenu.CustomData(this.selectedRecipe.get(), this.searchNeighbours.get(), this.isNodePowered() ? 1 : 0);
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)WorkbenchBlock.POWERED)) {
            return (Boolean)state.getValue((Property)WorkbenchBlock.POWERED);
        }
        return false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)WorkbenchBlock.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)WorkbenchBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void startOpen(Player player) {
        super.startOpen(player);
        this.setUser(player);
    }

    @Override
    public void stopOpen(Player player) {
        super.stopOpen(player);
        this.setUser(null);
    }

    public boolean canTakeItem(Container container, int slotIndex, ItemStack stack) {
        return slotIndex != 12;
    }

    @Override
    public boolean canPlaceItem(int slotIndex, ItemStack stack) {
        return slotIndex != 12;
    }

    public boolean isOccupied() {
        return this.getUser() != null;
    }

    @Nullable
    public Player getUser() {
        WorkbenchMenu menu;
        AbstractContainerMenu abstractContainerMenu;
        if (this.currentUser != null && this.currentUser.isAlive() && (abstractContainerMenu = this.currentUser.containerMenu) instanceof WorkbenchMenu && (menu = (WorkbenchMenu)abstractContainerMenu).getContainer() == this) {
            return this.currentUser;
        }
        return null;
    }

    public void setUser(@Nullable Player player) {
        if (!this.isOccupied() || player == null) {
            this.currentUser = player;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WorkbenchBlockEntity workbench) {
        workbench.sendCountsToUser(false);
    }

    public void sendCountsToUser(boolean force) {
        Player player = this.getUser();
        if (player != null && (this.updateTimer++ % 4 == 0 || force)) {
            Map<Item, Integer> newCounts = Utils.countItems(true, this.getSupplyContainers());
            int hash = newCounts.hashCode();
            if (hash == this.countsHash && !force) {
                return;
            }
            this.countsHash = hash;
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            for (Map.Entry<Item, Integer> entry : newCounts.entrySet()) {
                map.put(Item.getId((Item)entry.getKey()), entry.getValue());
            }
            ((WorkbenchMenu)player.containerMenu).updateItemCounts((Map<Integer, Integer>)map);
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageWorkbench.ItemCounts((Map<Integer, Integer>)map));
        }
    }

    @Override
    public void performCraft(RecipeHolder<WorkbenchContructingRecipe> recipe) {
        Map<Item, Integer> items = this.getConsumedMaterialItems((WorkbenchContructingRecipe)recipe.value());
        if (items != null) {
            this.removeItems(items);
        }
    }

    @Override
    public boolean canCraft(RecipeHolder<WorkbenchContructingRecipe> recipe) {
        return this.isNodePowered() && this.getConsumedMaterialItems((WorkbenchContructingRecipe)recipe.value()) != null;
    }

    @Override
    public DataSlot selectedRecipeDataSlot() {
        return this.selectedRecipe;
    }

    @Override
    public DataSlot searchNeighboursDataSlot() {
        return this.searchNeighbours;
    }

    @Override
    public Container getWorkbenchContainer() {
        return this;
    }

    @Override
    public ContainerLevelAccess createLevelAccess() {
        return ContainerLevelAccess.create((Level)Objects.requireNonNull(this.level), (BlockPos)this.worldPosition);
    }

    protected boolean shouldSearchNeighbours() {
        return this.searchNeighbours.get() != 0;
    }

    @Nullable
    private Map<Item, Integer> getConsumedMaterialItems(WorkbenchContructingRecipe recipe) {
        Map<Item, Integer> counts = Utils.countItems(true, this.getSupplyContainers());
        HashMap<Item, Integer> materials = new HashMap<Item, Integer>();
        for (StackedIngredient material : recipe.getMaterials()) {
            int remaining = material.count();
            for (ItemStack stack : material.ingredient().getItems()) {
                Item item = stack.getItem();
                int count = counts.getOrDefault(item, 0);
                if ((count -= materials.getOrDefault(item, 0).intValue()) <= 0) continue;
                if (count >= remaining) {
                    materials.merge(item, remaining, Integer::sum);
                    remaining = 0;
                    break;
                }
                materials.merge(item, count, Integer::sum);
                remaining -= count;
            }
            if (remaining <= 0) continue;
            return null;
        }
        return materials;
    }

    private boolean removeItems(Map<Item, Integer> items) {
        ArrayList transactions = new ArrayList();
        for (Pair<Direction, Container> pair2 : this.getSupplyContainers()) {
            Direction direction = (Direction)pair2.first();
            Container container = (Container)pair2.second();
            Utils.getContainerSlots(container, direction).forEach(slot -> {
                ItemStack stack = container.getItem(slot);
                if (stack.isEmpty() || stack.isDamaged()) {
                    return;
                }
                if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
                    return;
                }
                Item item = stack.getItem();
                Integer count = (Integer)items.get(item);
                if (count != null) {
                    if (stack.getCount() < count) {
                        count = count - stack.getCount();
                        items.put(item, count);
                        transactions.add(Pair.of((Object)container, () -> stack.setCount(0)));
                    } else {
                        Integer finalCount = count;
                        transactions.add(Pair.of((Object)container, () -> stack.shrink(finalCount.intValue())));
                        items.remove(item);
                    }
                }
            });
        }
        if (items.isEmpty()) {
            transactions.forEach(pair -> {
                ((Runnable)pair.right()).run();
                ((Container)pair.left()).setChanged();
            });
            return true;
        }
        return false;
    }

    private List<Pair<Direction, Container>> getSupplyContainers() {
        ArrayList<Pair<Direction, Container>> list = new ArrayList<Pair<Direction, Container>>();
        list.add(Pair.of(null, (Object)this));
        if (this.shouldSearchNeighbours()) {
            Direction direction = this.getDirection();
            this.getContainer(direction).ifPresent(list::add);
            this.getContainer(direction.getOpposite()).ifPresent(list::add);
            this.getContainer(direction.getCounterClockWise()).ifPresent(list::add);
            this.getContainer(direction.getClockWise()).ifPresent(list::add);
        }
        Optional.ofNullable(this.getUser()).ifPresent(player -> list.add(Pair.of(null, (Object)player.getInventory())));
        return list;
    }

    private Optional<Pair<Direction, Container>> getContainer(Direction offset) {
        BlockPos pos;
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(pos = this.worldPosition.relative(offset))) instanceof Container) {
            Container container = (Container)blockEntity;
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (container instanceof ChestBlockEntity && block instanceof ChestBlock) {
                container = ChestBlock.getContainer((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)this.level, (BlockPos)pos, (boolean)true);
            }
            if (container != null) {
                return Optional.of(Pair.of((Object)offset.getOpposite(), (Object)container));
            }
        }
        return Optional.empty();
    }

    private Direction getDirection() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            return (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("SelectedRecipe", 3)) {
            this.selectedRecipe.set(tag.getInt("SelectedRecipe"));
        }
        if (tag.contains("IncludeNeighbours", 1)) {
            this.searchNeighbours.set(tag.getBoolean("IncludeNeighbours") ? 1 : 0);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("SelectedRecipe", this.selectedRecipe.get());
        tag.putBoolean("IncludeNeighbours", this.searchNeighbours.get() != 0);
    }
}

