/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.requirement.ConditionResolver;
import net.blay09.mods.waystones.api.requirement.ParameterSerializer;
import net.blay09.mods.waystones.api.requirement.RequirementFunction;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredCondition;
import net.blay09.mods.waystones.requirement.ConfiguredRequirement;
import net.blay09.mods.waystones.requirement.ConfiguredRequirementModifier;
import net.blay09.mods.waystones.requirement.RequirementRegistry;
import net.minecraft.resources.ResourceLocation;

public class RequirementModifierParser {
    public static Optional<ConfiguredRequirementModifier<?, ?>> parse(String input) {
        try {
            int conditionsStart = input.indexOf(91);
            int conditionsEnd = input.indexOf(93);
            String conditionsPart = conditionsStart != -1 && conditionsEnd != -1 ? input.substring(conditionsStart + 1, conditionsEnd) : "";
            String functionPart = input.substring(conditionsEnd + 1).trim();
            List<ConfiguredCondition<?>> conditions = RequirementModifierParser.parseConditions(conditionsPart);
            ConfiguredRequirement<?, ?> requirement = RequirementModifierParser.parseRequirement(functionPart);
            return Optional.of(new ConfiguredRequirementModifier(requirement, conditions));
        }
        catch (Exception e) {
            Waystones.logger.error("Could not parse warp requirement", (Throwable)e);
            return Optional.empty();
        }
    }

    private static List<ConfiguredCondition<?>> parseConditions(String conditionsPart) {
        ArrayList conditions = new ArrayList();
        Pattern conditionPattern = Pattern.compile("([\\w:]+)(?:\\((.*?)\\))?");
        Matcher conditionMatcher = conditionPattern.matcher(conditionsPart);
        while (conditionMatcher.find()) {
            ResourceLocation conditionId = RequirementModifierParser.waystonesResourceLocation(conditionMatcher.group(1));
            String args = conditionMatcher.group(2);
            ConditionResolver<?> conditionResolver = RequirementRegistry.getConditionResolver(conditionId);
            conditions.add(RequirementModifierParser.parseCondition(conditionResolver, args != null ? args : ""));
        }
        return conditions;
    }

    private static <P> ConfiguredCondition<P> parseCondition(ConditionResolver<P> conditionResolver, String args) {
        P parameters = RequirementModifierParser.deserializeParameter(conditionResolver.getParameterType(), args);
        return new ConfiguredCondition<P>(conditionResolver, parameters);
    }

    private static ConfiguredRequirement<?, ?> parseRequirement(String functionPart) {
        Pattern functionPattern = Pattern.compile("(\\w+)\\((.*?)\\)");
        Matcher functionMatcher = functionPattern.matcher(functionPart);
        if (functionMatcher.find()) {
            ResourceLocation requirementId = RequirementModifierParser.waystonesResourceLocation(functionMatcher.group(1));
            String args = functionMatcher.group(2);
            RequirementFunction requirement = RequirementRegistry.getRequirementFunction(requirementId);
            return RequirementModifierParser.parseRequirement(requirement, args != null ? args : "");
        }
        throw new IllegalArgumentException("Invalid format for requirement modifier: '" + functionPart + "'");
    }

    private static <T extends WarpRequirement, P> ConfiguredRequirement<T, P> parseRequirement(RequirementFunction<T, P> requirement, String args) {
        P parameters = RequirementModifierParser.deserializeParameter(requirement.getParameterType(), args);
        return new ConfiguredRequirement<T, P>(requirement, parameters);
    }

    public static ResourceLocation waystonesResourceLocation(String value) {
        int colon = value.indexOf(58);
        String namespace = colon != -1 ? value.substring(0, colon) : "waystones";
        String path = colon != -1 ? value.substring(colon + 1) : value;
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static <T> T deserializeParameter(Class<T> type, String value) {
        ParameterSerializer<T> serializer = RequirementRegistry.getParameterSerializer(type);
        if (serializer == null) {
            throw new IllegalArgumentException("No serializer registered for type " + String.valueOf(type));
        }
        return serializer.deserialize(value);
    }

    public static <T> T deserializeParameterList(Class<T> type, String commaSeparatedParameters) {
        Constructor<?> constructor = type.getConstructors()[0];
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        String[] parameters = commaSeparatedParameters.split(",");
        if (parameters.length != parameterTypes.length) {
            throw new IllegalArgumentException("Parameter count mismatch for type " + String.valueOf(type));
        }
        Object[] parameterValues = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterValues[i] = RequirementModifierParser.deserializeParameter(parameterTypes[i], parameters[i].trim());
        }
        try {
            return (T)constructor.newInstance(parameterValues);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

