/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageStarting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class KeyEvents {
    private boolean wasStartPressed;
    private boolean wasGuiPressed;
    private boolean wasHornPressed;
    private boolean wasCenterPressed;

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        Entity riding = player.getVehicle();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (player.equals((Object)car.getDriver())) {
            car.updateControls(Main.FORWARD_KEY.isDown(), Main.BACK_KEY.isDown(), Main.LEFT_KEY.isDown(), Main.RIGHT_KEY.isDown(), (Player)player);
            if (Main.START_KEY.isDown()) {
                if (!this.wasStartPressed) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageStarting(true, false, (Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.wasStartPressed = true;
                }
            } else {
                if (this.wasStartPressed) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageStarting(false, true, (Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.wasStartPressed = false;
            }
            if (Main.HORN_KEY.isDown()) {
                if (!this.wasHornPressed) {
                    car.onHornPressed((Player)player);
                    this.wasHornPressed = true;
                }
            } else {
                this.wasHornPressed = false;
            }
            if (Main.CENTER_KEY.isDown()) {
                if (!this.wasCenterPressed) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageCenterCar((Player)player), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.displayClientMessage((Component)Component.translatable((String)"message.center_car"), true);
                    this.wasCenterPressed = true;
                }
            } else {
                this.wasCenterPressed = false;
            }
        }
        if (Main.CAR_GUI_KEY.isDown()) {
            if (!this.wasGuiPressed) {
                car.openCarGUI((Player)player);
                this.wasGuiPressed = true;
            }
        } else {
            this.wasGuiPressed = false;
        }
    }
}

