/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageStarting
implements Message<MessageStarting> {
    public static final CustomPacketPayload.Type<MessageStarting> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"starting"));
    private boolean start;
    private boolean playSound;
    private UUID uuid;

    public MessageStarting() {
    }

    public MessageStarting(boolean start, boolean playSound, Player player) {
        this.start = start;
        this.playSound = playSound;
        this.uuid = player.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            Main.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity entity = sender.getVehicle();
        if (!(entity instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)entity;
        if (sender.equals((Object)car.getDriver())) {
            car.setStarting(this.start, this.playSound);
        }
    }

    @Override
    public MessageStarting fromBytes(RegistryFriendlyByteBuf buf) {
        this.start = buf.readBoolean();
        this.playSound = buf.readBoolean();
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.start);
        buf.writeBoolean(this.playSound);
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageStarting> type() {
        return TYPE;
    }
}

