/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.ui;

import java.awt.Component;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class TranslationTarget<J extends Component> {
    public static final TranslationTarget<JLabel> LABEL_TEXT = new TranslationTarget<JLabel>(JLabel::setText);
    public static final TranslationTarget<AbstractButton> BUTTON_TEXT = new TranslationTarget<AbstractButton>(AbstractButton::setText);
    public static final TranslationTarget<JComponent> TOOLTIP = new TranslationTarget<JComponent>(JComponent::setToolTipText);
    private static final Map<TranslationTarget, TranslationTarget> HTML_TARGETS = new IdentityHashMap<TranslationTarget, TranslationTarget>();
    final BiConsumer<? super J, String> setter;

    public static <J extends Component> TranslationTarget<J> html(TranslationTarget<J> target) {
        return HTML_TARGETS.computeIfAbsent(target, k -> new TranslationTarget<Object>((c, s) -> k.setter.accept(c, "<html>" + s + "</html>")));
    }

    public TranslationTarget(BiConsumer<J, String> setter) {
        this.setter = setter;
    }
}

