/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.codecs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;

public class EnumCodec {
    public static <T extends Enum<T>> Codec<T> create(Class<T> enumClass, Function<String, T> valueOf) {
        return Codec.STRING.flatXmap(name -> {
            try {
                Enum e = (Enum)valueOf.apply((String)name);
                return DataResult.success((Object)e);
            }
            catch (IllegalArgumentException ignored) {
                return DataResult.error(() -> "Unknown enum name: '" + name + "' for enum class: " + String.valueOf(enumClass));
            }
        }, e -> {
            String name = e.name();
            return DataResult.success((Object)name);
        });
    }
}

