/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.StorageCabinetBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class StorageCabinetBlock
extends FurnitureHorizontalEntityBlock {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;

    public StorageCabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)context.getHorizontalDirection());
        BlockPos pos = context.getClickedPos();
        Vec3 clickVec = context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        Direction forward = context.getHorizontalDirection();
        Direction right = forward.getClockWise();
        double side = right.getAxis().choose(clickVec.x, 0.0, clickVec.z);
        side = Math.abs((double)Math.min(right.getAxisDirection().getStep(), 0) + side);
        return (BlockState)state.setValue(HINGE, (Comparable)(side > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (((Direction)state.getValue((Property)DIRECTION)).getOpposite() == result.getDirection()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof StorageCabinetBlockEntity) {
                StorageCabinetBlockEntity storageCabinet = (StorageCabinetBlockEntity)blockEntity;
                player.openMenu((MenuProvider)storageCabinet);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPEN});
        builder.add(new Property[]{HINGE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StorageCabinetBlockEntity(pos, state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StorageCabinetBlockEntity) {
            StorageCabinetBlockEntity storageCabinet = (StorageCabinetBlockEntity)blockEntity;
            storageCabinet.updateOpenerCount();
        }
    }
}

