/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class DeferredElectricRenderer {
    private static DeferredElectricRenderer instance;
    private final ResourceLocation nodeTexture = Utils.resource("textures/misc/electricity_nodes.png");
    private final List<BiConsumer<PoseStack, VertexConsumer>> builders = new LinkedList<BiConsumer<PoseStack, VertexConsumer>>();

    public static DeferredElectricRenderer get() {
        if (instance == null) {
            instance = new DeferredElectricRenderer();
        }
        return instance;
    }

    private DeferredElectricRenderer() {
    }

    public void draw(PoseStack pose) {
        Minecraft mc = Minecraft.getInstance();
        RenderTarget target = mc.levelRenderer.entityTarget();
        if (target == null || this.builders.isEmpty()) {
            return;
        }
        if (((Boolean)Config.CLIENT.experimental.electricityShadersFix.get()).booleanValue()) {
            target.clear(Minecraft.ON_OSX);
        }
        target.bindWrite(false);
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.nodeTexture);
        pose.pushPose();
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (BiConsumer<PoseStack, VertexConsumer> consumer : this.builders) {
            consumer.accept(pose, (VertexConsumer)builder);
        }
        MeshData data = builder.build();
        if (data != null) {
            BufferUploader.drawWithShader((MeshData)data);
        }
        pose.popPose();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        mc.getMainRenderTarget().bindWrite(false);
        this.builders.clear();
    }

    public void deferDraw(BiConsumer<PoseStack, VertexConsumer> consumer) {
        this.builders.add(consumer);
    }

    public void drawColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)FastColor.ARGB32.red((int)colour) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)colour) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxV, minU).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minV, minU).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minV, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxV, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawInvertedColouredBox(Matrix4f matrix, VertexConsumer consumer, AABB box, int colour, float alpha) {
        float red = (float)FastColor.ARGB32.red((int)colour) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)colour) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)colour) / 255.0f;
        float minU = 0.0f;
        float minV = 0.25f;
        float maxU = minU + 0.25f;
        float maxV = minV + 0.25f;
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, maxV).setColor(red, green, blue, alpha);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, maxV).setColor(red, green, blue, alpha);
    }

    public void drawTexturedBox(Matrix4f matrix, VertexConsumer consumer, AABB box, float minU, float minV, float maxU, float maxV) {
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(maxV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(minV, minU).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(minV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(maxV, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(maxU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(minU, minV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(minU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(maxU, maxV).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

