/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.neoforge.platform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import mezz.jei.library.util.BrewingRecipeMakerCommon;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<IJeiBrewingRecipe> getBrewingRecipes(IIngredientManager ingredientManager, IVanillaRecipeFactory vanillaRecipeFactory, PotionBrewing potionBrewing) {
        List brewingRecipes = potionBrewing.getRecipes();
        Set<IJeiBrewingRecipe> recipes = BrewingRecipeMakerCommon.getVanillaBrewingRecipes(vanillaRecipeFactory, ingredientManager, potionBrewing);
        IIngredientHelper<ItemStack> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        BrewingRecipeMaker.addModdedBrewingRecipes(vanillaRecipeFactory, itemStackHelper, brewingRecipes, recipes);
        ArrayList<IJeiBrewingRecipe> recipeList = new ArrayList<IJeiBrewingRecipe>(recipes);
        recipeList.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        return recipeList;
    }

    private static void addModdedBrewingRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientHelper<ItemStack> itemStackHelper, Collection<IBrewingRecipe> brewingRecipes, Collection<IJeiBrewingRecipe> recipes) {
        HashSet<Class> unhandledRecipeClasses = new HashSet<Class>();
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            if (iBrewingRecipe instanceof BrewingRecipe) {
                BrewingRecipe brewingRecipe = (BrewingRecipe)iBrewingRecipe;
                ItemStack[] ingredients = brewingRecipe.getIngredient().getItems();
                if (ingredients.length <= 0) continue;
                Ingredient inputIngredient = brewingRecipe.getInput();
                ItemStack output = brewingRecipe.getOutput();
                List<ItemStack> inputs = Arrays.stream(inputIngredient.getItems()).filter(i -> !i.isEmpty()).toList();
                if (output.isEmpty() || inputs.isEmpty()) continue;
                String outputModId = itemStackHelper.getResourceLocation(output).getNamespace();
                String outputUid = PotionSubtypeInterpreter.INSTANCE.getStringName(output);
                String uidPath = ResourceLocationUtil.sanitizePath(outputUid);
                IJeiBrewingRecipe recipe = vanillaRecipeFactory.createBrewingRecipe(List.of(ingredients), inputs, output, ResourceLocation.fromNamespaceAndPath((String)outputModId, (String)uidPath));
                recipes.add(recipe);
                continue;
            }
            Class recipeClass = iBrewingRecipe.getClass();
            if (unhandledRecipeClasses.contains(recipeClass)) continue;
            unhandledRecipeClasses.add(recipeClass);
            LOGGER.debug("Can't handle brewing recipe class: {}", (Object)recipeClass);
        }
    }
}

