/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PumpkinPatchFeature
extends Feature<NoneFeatureConfiguration> {
    public PumpkinPatchFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        for (int j = 0; j < 64; ++j) {
            BlockPos blockpos = pos.offset(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)world, (BlockPos)blockpos) || world.getBlockState(blockpos.below()).getBlock() != Blocks.GRASS_BLOCK) continue;
            if (rand.nextInt(3) == 0) {
                int num = rand.nextInt(50);
                if (num > 10) {
                    world.setBlock(blockpos, Blocks.PUMPKIN.defaultBlockState(), 2);
                } else if (num > 1) {
                    world.setBlock(blockpos, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.from3DDataValue((int)(2 + rand.nextInt(4)))), 2);
                } else {
                    world.setBlock(blockpos, (BlockState)Blocks.JACK_O_LANTERN.defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.from3DDataValue((int)(2 + rand.nextInt(4)))), 2);
                }
            } else {
                world.setBlock(blockpos, (BlockState)Blocks.OAK_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
            }
            ++i;
        }
        return i > 0;
    }
}

