/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class TidepoolFeature
extends Feature<NoneFeatureConfiguration> {
    public TidepoolFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        BlockState linerBlock = switch (rand.nextInt(7)) {
            default -> BOPBlocks.WHITE_SANDSTONE.defaultBlockState();
            case 1 -> Blocks.DEAD_TUBE_CORAL_BLOCK.defaultBlockState();
            case 2 -> Blocks.DEAD_BRAIN_CORAL_BLOCK.defaultBlockState();
            case 3 -> Blocks.DEAD_BUBBLE_CORAL_BLOCK.defaultBlockState();
            case 4 -> Blocks.DEAD_FIRE_CORAL_BLOCK.defaultBlockState();
            case 5 -> Blocks.DEAD_HORN_CORAL_BLOCK.defaultBlockState();
        };
        for (int j = 0; j < 96; ++j) {
            BlockPos blockpos = pos.offset(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(4) - rand.nextInt(4));
            boolean canPlace = true;
            if (!world.getBlockState(blockpos.above()).is(BlockTags.REPLACEABLE) || !world.getFluidState(blockpos.above()).is(Fluids.EMPTY)) {
                canPlace = false;
            }
            if (!world.getBlockState(blockpos).is(ModTags.Blocks.TIDEPOOL_REPLACEABLE) || !world.getBlockState(blockpos.below()).is(ModTags.Blocks.TIDEPOOL_REPLACEABLE)) {
                canPlace = false;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (world.getBlockState(blockpos.relative(direction)).is(ModTags.Blocks.TIDEPOOL_REPLACEABLE) || world.getFluidState(blockpos.relative(direction)).is((Fluid)Fluids.WATER)) continue;
                canPlace = false;
            }
            if (!canPlace) continue;
            BlockState coral = switch (rand.nextInt(12)) {
                default -> Blocks.DEAD_TUBE_CORAL.defaultBlockState();
                case 1 -> Blocks.DEAD_BRAIN_CORAL.defaultBlockState();
                case 2 -> Blocks.DEAD_BUBBLE_CORAL.defaultBlockState();
                case 3 -> Blocks.DEAD_FIRE_CORAL.defaultBlockState();
                case 4 -> Blocks.DEAD_HORN_CORAL.defaultBlockState();
                case 5 -> Blocks.DEAD_TUBE_CORAL_FAN.defaultBlockState();
                case 6 -> Blocks.DEAD_BRAIN_CORAL_FAN.defaultBlockState();
                case 7 -> Blocks.DEAD_BUBBLE_CORAL_FAN.defaultBlockState();
                case 8 -> Blocks.DEAD_FIRE_CORAL_FAN.defaultBlockState();
                case 9 -> Blocks.DEAD_HORN_CORAL_FAN.defaultBlockState();
                case 10 -> (BlockState)BOPBlocks.BARNACLES.defaultBlockState().setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true));
                case 11 -> (BlockState)Blocks.GLOW_LICHEN.defaultBlockState().setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(true));
            };
            world.setBlock(blockpos.below(), linerBlock, 2);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (world.getFluidState(blockpos.relative(direction)).is((Fluid)Fluids.WATER)) continue;
                world.setBlock(blockpos.relative(direction), linerBlock, 2);
            }
            world.setBlock(blockpos, (BlockState)coral.setValue((Property)BaseCoralPlantTypeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
            world.setBlock(blockpos.above(), Blocks.AIR.defaultBlockState(), 2);
            ++i;
        }
        return i > 0;
    }
}

