/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.gson.annotations.Since;
import java.util.Comparator;
import java.util.EnumSet;
import journeymap.client.cartography.color.RGB;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;

public class BlockStateColor
implements Comparable<BlockStateColor> {
    @Since(value=5.45)
    public String block;
    @Since(value=5.45)
    public String state;
    @Since(value=5.2)
    public String name;
    @Since(value=5.2)
    public String color;
    @Since(value=5.2)
    public Float alpha;
    @Since(value=6.0)
    public EnumSet<BlockFlag> flags;

    BlockStateColor(BlockMD blockMD, Integer color) {
        this.block = blockMD.getBlockId();
        this.state = blockMD.getBlockStateId();
        this.name = blockMD.getName();
        this.color = RGB.toHexString(color);
        this.alpha = Float.valueOf(blockMD.getAlpha());
        this.flags = blockMD.getFlags().clone();
    }

    BlockStateColor(String color, Float alpha) {
        this.color = color;
        this.alpha = Float.valueOf(alpha == null ? 1.0f : alpha.floatValue());
    }

    BlockStateColor(String block, String state, String color, Float alpha, EnumSet<BlockFlag> flags) {
        this.block = block;
        this.state = state;
        this.color = color;
        this.alpha = Float.valueOf(alpha == null ? 1.0f : alpha.floatValue());
        this.flags = flags == null ? null : flags.clone();
    }

    BlockStateColor(BlockStateColor blockStateColor) {
        this.block = blockStateColor.block;
        this.state = blockStateColor.state;
        this.name = blockStateColor.name;
        this.color = blockStateColor.color;
        this.alpha = blockStateColor.alpha;
        this.flags = blockStateColor.flags == null ? null : blockStateColor.flags.clone();
    }

    @Override
    public int compareTo(BlockStateColor that) {
        Ordering ordering = Ordering.natural().nullsLast();
        return ComparisonChain.start().compare((Object)this.name, (Object)that.name, (Comparator)ordering).compare((Object)this.block, (Object)that.block, (Comparator)ordering).compare((Object)this.state, (Object)that.state, (Comparator)ordering).compare((Object)this.color, (Object)that.color, (Comparator)ordering).compare((Object)this.alpha, (Object)that.alpha, (Comparator)ordering).compare(this.flags, that.flags, (Comparator)ordering).result();
    }
}

