/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.awt.Color;
import journeymap.api.v2.client.option.KeyedEnum;
import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.texture.TextureCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class GridSpec {
    public final Style style;
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;
    private int colorX = -1;
    private int colorY = -1;

    public GridSpec(Style style, Color color, float alpha) {
        this.style = style;
        float[] rgb = RGB.floats(color.getRGB());
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        while (alpha > 1.0f) {
            alpha /= 100.0f;
        }
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec(Style style, float red, float green, float blue, float alpha) {
        this.style = style;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec setColorCoords(int x, int y) {
        this.colorX = x;
        this.colorY = y;
        return this;
    }

    public RenderType getRenderType(int zoom) {
        if (zoom >= 512) {
            return JMRenderTypes.getGridLines(this.style.textureLocation);
        }
        return JMRenderTypes.GRID_LINES_RENDER_TYPE;
    }

    public GridSpec clone() {
        return new GridSpec(this.style, this.red, this.green, this.blue, this.alpha).setColorCoords(this.colorX, this.colorY);
    }

    public Integer getColor() {
        return RGB.toInteger(this.red, this.green, this.blue);
    }

    public int getColorX() {
        return this.colorX;
    }

    public int getColorY() {
        return this.colorY;
    }

    public static enum Style implements KeyedEnum
    {
        Squares("jm.common.grid_style_squares", TextureCache.GridSquares, true, false),
        SquaresWithRegion("jm.common.grid_style_squares_region", TextureCache.GridRegionSquares, true, true),
        GridRegion("jm.common.grid_style_region", TextureCache.GridRegion, false, true);

        private final String key;
        private final ResourceLocation textureLocation;
        private final boolean chunkLines;
        private final boolean regionLines;

        private Style(String key, ResourceLocation textureLocation, boolean chunkLines, boolean regionLines) {
            this.key = key;
            this.textureLocation = textureLocation;
            this.chunkLines = chunkLines;
            this.regionLines = regionLines;
        }

        public String displayName() {
            return Constants.getString(this.key);
        }

        public String getKey() {
            return this.key;
        }

        public boolean hasChunkLines() {
            return this.chunkLines;
        }

        public boolean hasRegionLines() {
            return this.regionLines;
        }
    }
}

