/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.buttons.Button;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;

public class ToggleButton
extends Button {
    private static final DynamicTexture ON = TextureCache.getTexture(TextureCache.TOGGLE_ON);
    private static final DynamicTexture OFF = TextureCache.getTexture(TextureCache.TOGGLE_OFF);
    private static boolean toggled = true;

    public ToggleButton() {
        super("");
    }

    public ToggleButton(String label, Button.OnPress onPress) {
        super(label, onPress);
    }

    public ToggleButton(int width, int height, String label, Button.OnPress onPress) {
        super(width, height, label, onPress);
    }

    private DynamicTexture getHandleSprite() {
        return toggled ? ON : OFF;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.setSize(40, 20);
        DrawUtil.drawQuad(graphics.pose(), this.getHandleSprite(), super.getX(), super.getY() - 7, 40.0, 35.0, false, 0.0);
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean clicked = super.mouseClicked(x, y, button);
        if (clicked) {
            toggled = !toggled;
        }
        return clicked;
    }
}

