/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import journeymap.client.io.FileHandler;
import journeymap.common.Journeymap;
import journeymap.common.codecs.WaypointCodecs;
import journeymap.common.codecs.WaypointGroupCodecs;
import journeymap.common.nbt.waypoint.WaypointDAO;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;

public class ClientWaypointDAO
extends WaypointDAO {
    protected static final String DAT_FILE = "WaypointData.dat";

    public ClientWaypointDAO() {
        this.data = this.load();
    }

    @Override
    public Map<String, WaypointGroupImpl> decodeGroups(CompoundTag data) {
        LinkedHashMap<String, WaypointGroupImpl> groups = new LinkedHashMap<String, WaypointGroupImpl>();
        if (data.contains("groups")) {
            CompoundTag groupsTags = data.getCompound("groups");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
                if (!result.result().isPresent()) continue;
                WaypointGroupImpl group = (WaypointGroupImpl)result.result().get();
                groups.put(group.getGuid(), group);
            }
        }
        return groups;
    }

    @Override
    public CompoundTag encodeGroups(Collection<WaypointGroupImpl> groups) {
        CompoundTag tag = new CompoundTag();
        tag.put("groups", (Tag)new CompoundTag());
        CompoundTag groupsTag = tag.getCompound("groups");
        for (WaypointGroupImpl group : groups) {
            DataResult result = WaypointGroupCodecs.V1_WAYPOINT_GROUP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)group);
            if (!result.result().isPresent()) continue;
            groupsTag.put(group.getGuid(), (Tag)result.result().get());
        }
        return tag;
    }

    @Override
    public Map<String, WaypointImpl> decodeWaypoints(CompoundTag data) {
        LinkedHashMap<String, WaypointImpl> waypoints = new LinkedHashMap<String, WaypointImpl>();
        if (data.contains("waypoints")) {
            CompoundTag groupsTags = data.getCompound("waypoints");
            for (String key : groupsTags.getAllKeys()) {
                Tag tag = groupsTags.get(key);
                WaypointImpl waypoint = this.decodeWaypoint(tag);
                if (waypoint == null) continue;
                waypoints.put(waypoint.getGuid(), waypoint);
            }
        }
        return waypoints;
    }

    @Override
    public CompoundTag encodeWaypoints(Collection<WaypointImpl> waypoints) {
        CompoundTag tag = new CompoundTag();
        tag.put("waypoints", (Tag)new CompoundTag());
        CompoundTag wpTag = tag.getCompound("waypoints");
        for (WaypointImpl wp : waypoints) {
            Tag result = this.encodeWaypoint(wp);
            if (result == null) continue;
            wpTag.put(wp.getGuid(), result);
        }
        return tag;
    }

    @Override
    public WaypointImpl decodeWaypoint(Tag data) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data);
        if (result.result().isPresent()) {
            return (WaypointImpl)result.result().get();
        }
        return null;
    }

    @Override
    public Tag encodeWaypoint(WaypointImpl waypoint) {
        DataResult result = WaypointCodecs.V1_WAYPOINT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)waypoint);
        if (result.result().isPresent()) {
            return (Tag)result.result().get();
        }
        return null;
    }

    @Override
    public WaypointImpl copyWaypoint(WaypointImpl waypoint) {
        Tag rawCopy = this.encodeWaypoint(waypoint);
        if (rawCopy != null) {
            return this.decodeWaypoint(rawCopy);
        }
        return null;
    }

    private File getFile() {
        return new File(FileHandler.getWaypointDir(), DAT_FILE);
    }

    private void write(Path path) {
        try {
            NbtIo.write((CompoundTag)this.data, (Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void save(boolean async) {
        if (this.isDirty()) {
            Journeymap.getLogger().info("Saving WaypointData.dat async:{}", (Object)async);
            if (async) {
                CompletableFuture.runAsync(() -> this.write(this.getFile().toPath()), Util.ioPool());
            }
            this.write(this.getFile().toPath());
            this.setDirty(false);
        }
    }

    @Override
    public Map<String, WaypointGroupImpl> getGroups() {
        return this.decodeGroups(this.data);
    }

    @Override
    public Map<String, WaypointImpl> getWaypoints() {
        return this.decodeWaypoints(this.data);
    }

    private CompoundTag load() {
        try {
            if (this.getFile().exists()) {
                return NbtIo.read((Path)this.getFile().toPath());
            }
            return new CompoundTag();
        }
        catch (EOFException eof) {
            Journeymap.getLogger().error("WaypointData.dat file is corrupted. Deleting as it is unusable.", (Throwable)eof);
            if (this.getFile().exists()) {
                this.getFile().delete();
            }
            return new CompoundTag();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

