/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import journeymap.client.JourneymapClient;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.command.CmdChatPosition;
import journeymap.client.command.CmdEditWaypoint;
import journeymap.client.command.CmdReloadWaypoint;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;

public class ChatEventHandler {
    private final ClientCommandInvoker clientCommandInvoker = new ClientCommandInvoker();
    private static ChatEventHandler INSTANCE;

    private ChatEventHandler() {
        this.clientCommandInvoker.registerSub(new CmdChatPosition());
        this.clientCommandInvoker.registerSub(new CmdEditWaypoint());
        this.clientCommandInvoker.registerSub(new CmdReloadWaypoint());
    }

    public static ChatEventHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ChatEventHandler();
        }
        return INSTANCE;
    }

    public Component onClientChatEventReceived(Component message) {
        if (JourneymapClient.getInstance().enabled() && message != null) {
            try {
                String text = message.getString();
                if (!Strings.isNullOrEmpty((String)text)) {
                    return WaypointParser.parseChatForWaypoints(message, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
        return message;
    }

    public boolean onChatEvent(String message) {
        if (JourneymapClient.getInstance().enabled() && message.regionMatches(0, "/jm", 0, 3)) {
            if (message.length() > 3) {
                try {
                    LocalPlayer player = Minecraft.getInstance().player;
                    message = message.substring(4);
                    this.clientCommandInvoker.execute((CommandSource)player, message.split(" "));
                }
                catch (CommandSyntaxException e) {
                    Journeymap.getLogger().error((Object)e);
                }
            } else {
                String commands = this.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)text));
            }
            return true;
        }
        return false;
    }
}

