/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkMonitorHandler {
    private LevelAccessor world;
    private static ChunkMonitorHandler instance;

    private ChunkMonitorHandler() {
    }

    public static ChunkMonitorHandler getInstance() {
        if (instance == null) {
            instance = new ChunkMonitorHandler();
        }
        return instance;
    }

    public void reset() {
        this.world = null;
    }

    public void resetRenderTimes(long pos) {
        ChunkMD chunkMD;
        if (JourneymapClient.getInstance().enabled() && (chunkMD = DataCache.INSTANCE.getChunkMD(pos)) != null && Minecraft.getInstance().player != null && chunkMD.getChunk().getLevel() == Minecraft.getInstance().player.getCommandSenderWorld()) {
            chunkMD.resetRenderTimes();
        }
    }

    public void onChunkLoad(LevelAccessor world, ChunkAccess chunkAccess) {
        if (JourneymapClient.getInstance().enabled()) {
            LevelChunk chunk;
            if (world == null || !world.isClientSide() || !this.isLevelCurrent()) {
                return;
            }
            if (this.world == null) {
                this.world = world;
            }
            if ((chunk = (LevelChunk)chunkAccess) != null && Minecraft.getInstance().player != null && chunk.getLevel() == Minecraft.getInstance().player.getCommandSenderWorld()) {
                DataCache.INSTANCE.addChunkMD(new ChunkMD(chunk));
            }
        }
    }

    public void onWorldUnload(LevelAccessor world) {
        if (JourneymapClient.getInstance().enabled()) {
            try {
                if (world.equals((Object)this.world)) {
                    this.reset();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error handling WorldEvent.Unload", (Throwable)e);
            }
        }
    }

    public void onBlockUpdate(LevelAccessor world, BlockPos pos) {
        if (JourneymapClient.getInstance().enabled() && world != null && this.isLevelCurrent()) {
            int chunkX = pos.getX() >> 4;
            int chunkZ = pos.getZ() >> 4;
            this.markBlockRangeForRenderUpdate(chunkX * 16, chunkZ * 16, chunkX * 16 + 15, chunkZ * 16 + 15);
        }
    }

    public void onChunkUpdate(LevelAccessor world, ChunkPos pos) {
        if (JourneymapClient.getInstance().enabled() && world != null && this.isLevelCurrent()) {
            this.resetRenderTimes(pos.toLong());
        }
    }

    private void markBlockRangeForRenderUpdate(int x1, int z1, int x2, int z2) {
        int cx1 = x1 >> 4;
        int cz1 = z1 >> 4;
        int cx2 = x2 >> 4;
        int cz2 = z2 >> 4;
        if (cx1 == cx2 && cz1 == cz2) {
            this.resetRenderTimes(ChunkPos.asLong((int)cx1, (int)cz1));
        } else {
            for (int chunkXPos = cx1; chunkXPos < cx2; ++chunkXPos) {
                for (int chunkZPos = cz1; chunkZPos < cz2; ++chunkZPos) {
                    this.resetRenderTimes(ChunkPos.asLong((int)chunkXPos, (int)chunkZPos));
                }
            }
        }
    }

    private boolean isLevelCurrent() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level != null && mc.player != null && mc.level == mc.player.getCommandSenderWorld();
    }
}

