/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;

public class MapChat
extends ChatScreen {
    protected boolean hidden = false;
    protected int cursorCounter;

    public MapChat(String defaultText, boolean hidden) {
        super(defaultText);
        this.hidden = hidden;
    }

    public void removed() {
        super.removed();
        this.hidden = true;
    }

    public void close() {
        this.removed();
    }

    public void tick() {
        if (this.hidden) {
            return;
        }
        super.tick();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.hidden) {
            return false;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            return super.charTyped(typedChar, keyCode);
        }
        String s = this.input.getValue().trim();
        if (!s.isEmpty()) {
            this.handleChatInput(s, true);
        }
        this.input.setValue("");
        Minecraft.getInstance().gui.getChat().resetChatScroll();
        return true;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        if (key == 257 || key == 335) {
            String s = this.input.getValue().trim();
            if (!s.isEmpty()) {
                this.handleChatInput(s, true);
            }
            this.input.setValue("");
            Minecraft.getInstance().gui.getChat().resetChatScroll();
            this.close();
            return true;
        }
        return super.keyPressed(key, value, modifier);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.hidden) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, (float)this.height - 47.5f, 0.0f);
        if (this.minecraft != null && this.minecraft.gui != null) {
            int n;
            ChatComponent chatComponent = this.minecraft.gui.getChat();
            if (this.hidden) {
                n = this.minecraft.gui.getGuiTicks();
            } else {
                int n2 = this.cursorCounter;
                n = n2;
                this.cursorCounter = n2 + 1;
            }
            chatComponent.render(graphics, mouseX, mouseY, n, true);
        }
        graphics.pose().popPose();
        if (this.hidden) {
            return;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setText(String defaultText) {
        this.input.setValue(defaultText);
    }
}

