/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.Renderer;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaypointLayer
extends Layer {
    private final long hoverDelay = 5L;
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    private final BlockOutlineDrawStep clickDrawStep = new BlockOutlineDrawStep(this, BlockPos.ZERO);
    BlockPos lastCoord = null;
    float iconScale = 1.0f;
    long startHover = 0L;
    DrawWayPointStep selectedWaypointStep = null;
    ClientWaypointImpl selected = null;

    public WaypointLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.iconScale = JourneymapClient.getInstance().getFullMapProperties().waypointIconScale.get().floatValue();
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, Renderer renderer, Point2D.Double mousePosition, BlockPos blockCoord, float fontScale, boolean isScrolling) {
        this.drawStepList.clear();
        if (!WaypointsData.isManagerEnabled()) {
            return this.drawStepList;
        }
        if (this.lastCoord == null) {
            this.lastCoord = blockCoord;
        }
        long now = Util.getMillis();
        this.iconScale = JourneymapClient.getInstance().getFullMapProperties().waypointIconScale.get().floatValue();
        int proximity = (int)Math.max(1.0, 8.0 / renderer.getUIState().blockSize * (double)this.iconScale);
        if (this.clickDrawStep.blockCoord != null && (!blockCoord.equals((Object)this.clickDrawStep.blockCoord) || blockCoord.equals((Object)BlockPos.ZERO))) {
            this.unclick();
        } else {
            this.drawStepList.add(this.clickDrawStep);
        }
        AABB area = new AABB((double)(blockCoord.getX() - proximity), (double)(mc.level.dimensionType().minY() - 1), (double)(blockCoord.getZ() - proximity), (double)(blockCoord.getX() + proximity), (double)(mc.level.dimensionType().logicalHeight() + 1), (double)(blockCoord.getZ() + proximity));
        if (!this.lastCoord.equals((Object)blockCoord)) {
            if (!area.contains(new Vec3((double)this.lastCoord.getX(), 1.0, (double)this.lastCoord.getZ()))) {
                this.selected = null;
                this.lastCoord = blockCoord;
                this.startHover = now;
                return this.drawStepList;
            }
        } else if (this.selected != null) {
            this.select(this.selected);
            return this.drawStepList;
        }
        if (now - this.startHover < 5L) {
            return this.drawStepList;
        }
        Collection<ClientWaypointImpl> holders = DataCache.INSTANCE.getWaypoints(false);
        ArrayList<ClientWaypointImpl> proximal = new ArrayList<ClientWaypointImpl>();
        for (ClientWaypointImpl waypoint : holders) {
            if (!waypoint.isEnabled() || !waypoint.isInPlayerDimension() || !area.contains(new Vec3((double)waypoint.getX(), (double)waypoint.getY(), (double)waypoint.getZ()))) continue;
            proximal.add(waypoint);
        }
        if (!proximal.isEmpty()) {
            if (proximal.size() > 1) {
                this.sortByDistance(proximal, blockCoord);
            }
            this.select(proximal.get(0));
        }
        return this.drawStepList;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, Renderer renderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        if (!WaypointsData.isManagerEnabled()) {
            return this.drawStepList;
        }
        if (!this.drawStepList.contains(this.clickDrawStep)) {
            this.drawStepList.add(this.clickDrawStep);
        }
        if (!doubleClick) {
            this.click(renderer, blockCoord, button);
        } else {
            if (this.selected != null) {
                UIManager.INSTANCE.openWaypointEditor(this.selected, false);
                return this.drawStepList;
            }
            if (button == 0 && JourneymapClient.getInstance().getWaypointProperties().fullscreenDoubleClickToCreate.get().booleanValue()) {
                RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockCoord, renderer.getMapType());
                int y = blockCoord.getY();
                if (regionData != null) {
                    y = regionData.getTopY(blockCoord);
                }
                UIManager.INSTANCE.openWaypointEditor(null, new BlockPos(blockCoord.getX(), y + 1, blockCoord.getZ()), false);
            }
        }
        return this.drawStepList;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    private void sortByDistance(List<ClientWaypointImpl> holders, final BlockPos blockCoord) {
        Collections.sort(holders, new Comparator<ClientWaypointImpl>(this){

            @Override
            public int compare(ClientWaypointImpl o1, ClientWaypointImpl o2) {
                return Double.compare(this.getDistance(o1), this.getDistance(o2));
            }

            private double getDistance(ClientWaypointImpl holder) {
                double dx = holder.getX() - blockCoord.getX();
                double dz = holder.getZ() - blockCoord.getZ();
                return Math.sqrt(dx * dx + dz * dz);
            }
        });
    }

    private void select(ClientWaypointImpl holder) {
        this.selected = holder;
        this.selectedWaypointStep = new DrawWayPointStep(holder, true);
        this.selectedWaypointStep.setIconScale(this.iconScale);
        this.drawStepList.add(this.selectedWaypointStep);
    }

    private void click(Renderer renderer, BlockPos blockCoord, int button) {
        this.clickDrawStep.blockCoord = this.lastCoord = blockCoord;
        if (!this.drawStepList.contains(this.clickDrawStep)) {
            this.drawStepList.add(this.clickDrawStep);
        }
        if (button == 1 && this.selected != null && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
            ClientWaypointImpl wp = new ClientWaypointImpl((Waypoint)this.selected);
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockCoord, renderer.getMapType());
            if (regionData != null) {
                int y = regionData.getTopY(blockCoord);
                wp.setY(y + 1);
            }
            this.fullscreen.popupMenu.displayWaypointOptions(blockCoord, wp);
        }
    }

    private void unclick() {
        this.clickDrawStep.blockCoord = null;
        this.drawStepList.remove(this.clickDrawStep);
    }

    class BlockOutlineDrawStep
    implements DrawStep {
        BlockPos blockCoord;
        Point2D.Double pixel;

        BlockOutlineDrawStep(WaypointLayer this$0, BlockPos blockCoord) {
            this.blockCoord = blockCoord;
        }

        @Override
        public void draw(GuiGraphics graphics, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
            if (pass != DrawStep.Pass.Object) {
                return;
            }
            if (this.blockCoord == null) {
                return;
            }
            if (Minecraft.getInstance().mouseHandler.isLeftPressed()) {
                return;
            }
            if (xOffset != 0.0 || yOffset != 0.0) {
                return;
            }
            double size = renderer.getUIState().blockSize;
            double thick = (double)renderer.getZoom() / 512.0 < 2.0 ? 1.0 : 2.0;
            this.pixel = renderer.getBlockPixelInGrid(this.blockCoord);
            double x = this.pixel.x;
            double y = this.pixel.y;
            if (renderer.isOnScreen(this.pixel)) {
                DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick * thick, size + thick * 4.0, thick, 0, 0.6f);
                DrawUtil.drawRectangle(graphics, x - thick, y - thick, size + thick * thick, thick, 0xFFFFFF, 0.6f);
                DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick, thick, size + thick * thick, 0, 0.6f);
                DrawUtil.drawRectangle(graphics, x - thick, y, thick, size, 0xFFFFFF, 0.6f);
                DrawUtil.drawRectangle(graphics, x + size, y, thick, size, 0xFFFFFF, 0.6f);
                DrawUtil.drawRectangle(graphics, x + size + thick, y - thick, thick, size + thick * thick, 0, 0.6f);
                DrawUtil.drawRectangle(graphics, x - thick, y + size, size + thick * thick, thick, 0xFFFFFF, 0.6f);
                DrawUtil.drawRectangle(graphics, x - thick * thick, y + size + thick, size + thick * 4.0, thick, 0, 0.6f);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

