/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.waypoint.predefined;

import java.util.List;
import java.util.Optional;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.waypoint.GroupSettings;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointStore;
import journeymap.common.waypoint.predefined.LockedGroup;

public class AllWaypointsGroup
extends LockedGroup {
    public AllWaypointsGroup(String modId, String name, String guid) {
        super(modId, name, guid);
        this.settings.setLocked(true);
    }

    public AllWaypointsGroup(String name, String version, String modId, String guid, Optional<String> description, Optional<Integer> color, WaypointIcon icon, GroupSettings settings, Optional<String> customData) {
        super(name, version, modId, guid, description, color, icon, settings, customData);
        this.settings.setLocked(true);
    }

    @Override
    public List<String> getWaypointIds() {
        return WaypointStore.getInstance().getAll().stream().map(Waypoint::getGuid).toList();
    }

    @Override
    public boolean isEnabled() {
        List<ClientWaypointImpl> validWaypoints = WaypointStore.getInstance().getAll().stream().filter(wp -> WaypointGroupStore.getInstance().get(wp.getGroupId()).isEnabled()).toList();
        return validWaypoints.stream().filter(wp -> !wp.isEnabled()).toList().isEmpty();
    }

    @Override
    public void setEnabled(boolean enabled) {
        WaypointStore.toggleAllWaypoints();
    }
}

