/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.corelib.block.IItemBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockCrank
extends BlockBase
implements IItemBlock {
    public static final IntegerProperty CRANK_POS = IntegerProperty.create((String)"rotation", (int)0, (int)7);
    public static final VoxelShape SHAPE = Block.box((double)3.2, (double)0.0, (double)3.2, (double)12.8, (double)9.6, (double)12.8);

    public BlockCrank() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(0.5f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRANK_POS, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        BlockEntity te = level.getBlockEntity(blockPos.below());
        if (!(te instanceof TileEntityDynamo)) {
            return InteractionResult.FAIL;
        }
        TileEntityDynamo dyn = (TileEntityDynamo)te;
        dyn.addEnergy(dyn.generation);
        int i = (Integer)blockState.getValue((Property)CRANK_POS) + 1;
        if (i > 7) {
            i = 0;
        }
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)CRANK_POS, (Comparable)Integer.valueOf(i)), 3);
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CRANK_POS});
    }
}

