/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public abstract class EntityCarTemperatureBase
extends EntityCarBase {
    private static final EntityDataAccessor<Float> TEMPERATURE = SynchedEntityData.defineId(EntityCarTemperatureBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public EntityCarTemperatureBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void tick() {
        float tempToReach;
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        if (this.tickCount % 20 != 0) {
            return;
        }
        float speedPerc = this.getSpeed() / this.getMaxSpeed();
        int tempRate = (int)(speedPerc * 10.0f) + 1;
        if (tempRate > 5) {
            tempRate = 5;
        }
        float rate = (float)tempRate * 0.2f + (this.random.nextFloat() - 0.5f) * 0.1f;
        float temp = this.getTemperature();
        if (MathUtils.isInBounds(temp, tempToReach = this.getTemperatureToReach(), rate)) {
            this.setTemperature(tempToReach);
        } else {
            if (tempToReach < temp) {
                rate = -rate;
            }
            this.setTemperature(temp + rate);
        }
    }

    public float getTemperatureToReach() {
        float biomeTemp = this.getBiomeTemperatureCelsius();
        if (!this.isStarted()) {
            return biomeTemp;
        }
        float optimalTemp = this.getOptimalTemperature();
        if (biomeTemp > 45.0f) {
            optimalTemp = 100.0f;
        } else if (biomeTemp <= 0.0f) {
            optimalTemp = 80.0f;
        }
        return Math.max(biomeTemp, optimalTemp);
    }

    public float getBiomeTemperatureCelsius() {
        return (((Biome)this.level().getBiome(this.blockPosition()).value()).getTemperature(this.blockPosition()) - 0.3f) * 30.0f;
    }

    public float getTemperature() {
        return ((Float)this.entityData.get(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.entityData.set(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public abstract float getOptimalTemperature();

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TEMPERATURE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setTemperature(compound.getFloat("temperature"));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("temperature", this.getTemperature());
    }

    public void initTemperature() {
        this.setTemperature(this.getBiomeTemperatureCelsius());
    }
}

