/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.tools.EntityTools;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiCarWorkshopCrafting
extends ScreenBase<ContainerCarWorkshopCrafting> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_car_workshop_crafting.png");
    private TileEntityCarWorkshop tile;
    private Player player;
    private Button buttonSpawn;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopCrafting(ContainerCarWorkshopCrafting container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = playerInventory.player;
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    protected void init() {
        super.init();
        this.buttonRepair = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.repair_car"), button -> PacketDistributor.sendToServer((CustomPacketPayload)new MessageOpenCarWorkshopGui(this.tile.getBlockPos(), this.player, true), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 105, this.topPos + 72, 60, 20).build());
        this.buttonSpawn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.spawn_car"), button -> {
            if (this.tile.getLevel().isClientSide) {
                if (this.tile.isCurrentCraftingCarValid()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MessageSpawnCar(this.tile.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    for (Component message : this.tile.getMessages()) {
                        this.player.sendSystemMessage(message);
                    }
                }
            }
        }).bounds(this.leftPos + 105, this.topPos + 106, 60, 20).build());
        this.buttonSpawn.active = false;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.tile.getDisplayName().getVisualOrderText(), 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle.getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityCarBase carTop = this.tile.getCarOnTop();
        EntityGenericCar car = this.tile.getCurrentCraftingCar();
        if (carTop != null) {
            this.drawCar(guiGraphics, carTop);
            this.buttonSpawn.active = false;
        } else {
            if (car != null) {
                this.drawCar(guiGraphics, car);
            }
            this.buttonSpawn.active = true;
        }
    }

    public void containerTick() {
        super.containerTick();
        this.carRenderer.tick();
    }

    private void drawCar(GuiGraphics guiGraphics, EntityCarBase car) {
        this.carRenderer.render(guiGraphics, car, this.imageWidth / 2, 55, 23);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

