/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ItemCanister
extends Item {
    public ItemCanister() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getPlayer().isShiftKeyDown()) {
            return super.useOn(context);
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        BlockEntity te = state.getBlock().equals(ModBlocks.GAS_STATION_TOP.get()) ? context.getLevel().getBlockEntity(context.getClickedPos().below()) : context.getLevel().getBlockEntity(context.getClickedPos());
        if (te == null) {
            return super.useOn(context);
        }
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation fuel = (TileEntityGasStation)te;
            boolean success = ItemCanister.fillCanister(context.getPlayer().getItemInHand(context.getHand()), fuel);
            if (success) {
                ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, context.getLevel(), context.getClickedPos(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        if (te instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)te;
            boolean success = ItemCanister.fuelFluidHandler(context.getPlayer().getItemInHand(context.getHand()), handler);
            if (success) {
                ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, context.getLevel(), context.getClickedPos(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        SimpleFluidContent content = (SimpleFluidContent)stack.get(Main.FUEL_DATA_COMPONENT);
        if (content == null || content.isEmpty()) {
            this.addInfo("-", 0, tooltip);
            super.appendHoverText(stack, context, tooltip, flagIn);
            return;
        }
        FluidStack fluidStack = content.copy();
        this.addInfo(fluidStack.getHoverName().getString(), fluidStack.getAmount(), tooltip);
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    private void addInfo(String fluid, int amount, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"canister.fluid", (Object[])new Object[]{Component.literal((String)fluid).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"canister.amount", (Object[])new Object[]{Component.literal((String)String.valueOf(amount)).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
    }

    public static boolean fillCanister(ItemStack canister, IFluidHandler handler) {
        SimpleFluidContent content = (SimpleFluidContent)canister.get(Main.FUEL_DATA_COMPONENT);
        int maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get();
        if (content != null) {
            maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get() - content.getAmount();
        }
        if (maxAmount <= 0) {
            return false;
        }
        FluidStack resultSim = handler.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (resultSim.getAmount() <= 0) {
            return false;
        }
        if (content != null && !content.isEmpty() && !resultSim.getFluid().equals(content.getFluid())) {
            return false;
        }
        FluidStack result = handler.drain(maxAmount, IFluidHandler.FluidAction.EXECUTE);
        if (result.isEmpty()) {
            return false;
        }
        if (content == null || content.isEmpty()) {
            canister.set(Main.FUEL_DATA_COMPONENT, (Object)SimpleFluidContent.copyOf((FluidStack)result));
            return true;
        }
        if (result.getFluid().equals(content.getFluid())) {
            canister.set(Main.FUEL_DATA_COMPONENT, (Object)SimpleFluidContent.copyOf((FluidStack)new FluidStack(content.getFluid(), content.getAmount() + result.getAmount())));
        }
        return true;
    }

    public static boolean fuelFluidHandler(ItemStack canister, IFluidHandler handler) {
        SimpleFluidContent content = (SimpleFluidContent)canister.get(Main.FUEL_DATA_COMPONENT);
        if (content == null || content.isEmpty()) {
            return false;
        }
        FluidStack result = content.copy();
        int fueledAmount = handler.fill(result, IFluidHandler.FluidAction.EXECUTE);
        result.setAmount(result.getAmount() - fueledAmount);
        if (result.getAmount() <= 0) {
            canister.remove(Main.FUEL_DATA_COMPONENT);
            return true;
        }
        canister.set(Main.FUEL_DATA_COMPONENT, (Object)SimpleFluidContent.copyOf((FluidStack)result));
        return true;
    }
}

