/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.corelib.net.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageEditSign
implements Message<MessageEditSign> {
    public static final CustomPacketPayload.Type<MessageEditSign> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"edit_sign"));
    private BlockPos pos;
    private String[] text;

    public MessageEditSign() {
    }

    public MessageEditSign(BlockPos pos, String[] text) {
        this.pos = pos;
        this.text = text;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        BlockEntity blockEntity = sender.level().getBlockEntity(this.pos);
        if (blockEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)blockEntity;
            sign.setText(this.text);
        }
    }

    @Override
    public MessageEditSign fromBytes(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.text = new String[8];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = buf.readUtf(64);
        }
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        for (String s : this.text) {
            buf.writeUtf(s, 64);
        }
    }

    @Override
    public CustomPacketPayload.Type<MessageEditSign> type() {
        return TYPE;
    }
}

