/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.block.VoxelUtils;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;

public class BlockCable
extends BlockBase
implements EntityBlock,
IItemBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_NORTH = Block.box((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)6.5);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)9.5, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5);
    public static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5);
    public static final VoxelShape SHAPE_UP = Block.box((double)6.5, (double)9.5, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)6.5, (double)9.5);
    public static final VoxelShape SHAPE_CORE = Block.box((double)6.5, (double)6.5, (double)6.5, (double)9.5, (double)9.5, (double)9.5);

    protected BlockCable() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).strength(0.25f).sound(SoundType.WOOL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getState(context.getLevel(), context.getClickedPos());
    }

    private BlockState getState(Level world, BlockPos pos) {
        FluidState ifluidstate = world.getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(BlockCable.isConnectedTo(world, pos, Direction.WEST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.neighborChanged(state, world, pos, block, pos1, b);
        world.setBlockAndUpdate(pos, this.getState(world, pos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_WEST);
        }
        return shape;
    }

    public static boolean isConnectedTo(Level world, BlockPos pos, Direction facing) {
        BlockState state = world.getBlockState(pos.relative(facing));
        if (state.getBlock().equals(ModBlocks.CABLE.get())) {
            return true;
        }
        return world.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)facing.getOpposite()) != null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntityCable(blockPos, blockState);
    }
}

