/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.items.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SlotBattery
extends Slot {
    private EntityCarBatteryBase car;
    private Player player;

    public SlotBattery(EntityCarBatteryBase car, int index, int xPosition, int yPosition, Player player) {
        super((Container)new SimpleContainer(1), index, xPosition, yPosition);
        this.car = car;
        this.player = player;
    }

    public void set(ItemStack stack) {
        if (!stack.getItem().equals(ModItems.BATTERY.get())) {
            return;
        }
        int energy = stack.getMaxDamage() - stack.getDamageValue();
        int energyToFill = this.car.getMaxBatteryLevel() - this.car.getBatteryLevel();
        int fill = Math.min(energy, energyToFill);
        stack.setDamageValue(stack.getMaxDamage() - (energy - fill));
        this.car.setBatteryLevel(this.car.getBatteryLevel() + fill);
        if (!this.player.getInventory().add(stack)) {
            Containers.dropItemStack((Level)this.car.level(), (double)this.car.getX(), (double)this.car.getY(), (double)this.car.getZ(), (ItemStack)stack);
        }
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem().equals(ModItems.BATTERY.get());
    }
}

