/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.CarRecipeBuilder;
import de.maxhenkel.car.integration.jei.CarRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipe;
import de.maxhenkel.car.integration.jei.PainterRecipeCategory;
import de.maxhenkel.car.integration.jei.PainterRecipeCategoryYellow;
import de.maxhenkel.car.items.ModItems;
import java.util.Arrays;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final RecipeType<CarRecipe> CATEGORY_CAR_WORKSHOP = RecipeType.create((String)"car", (String)"car_workshop", CarRecipe.class);
    public static final RecipeType<PainterRecipe> CATEGORY_PAINTER = RecipeType.create((String)"car", (String)"painter", PainterRecipe.class);
    public static final RecipeType<PainterRecipe> CATEGORY_PAINTER_YELLOW = RecipeType.create((String)"car", (String)"painter_yellow", PainterRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.PAINTER.get()), new RecipeType[]{CATEGORY_PAINTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PAINTER_YELLOW.get()), new RecipeType[]{CATEGORY_PAINTER_YELLOW});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CAR_WORKSHOP.get()), new RecipeType[]{CATEGORY_CAR_WORKSHOP});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(CATEGORY_PAINTER, Arrays.stream(ModBlocks.PAINTS).map(paint -> new PainterRecipe((Item)ModItems.PAINTER.get(), (BlockPaint)paint.get())).toList());
        registration.addRecipes(CATEGORY_PAINTER_YELLOW, Arrays.stream(ModBlocks.YELLOW_PAINTS).map(paint -> new PainterRecipe((Item)ModItems.PAINTER_YELLOW.get(), (BlockPaint)paint.get())).toList());
        registration.addRecipes(CATEGORY_CAR_WORKSHOP, CarRecipeBuilder.getAllRecipes());
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.PAINTER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.painter_white")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.PAINTER_YELLOW.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.painter_yellow")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.CANISTER.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.canister")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.REPAIR_KIT.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.repair_kit")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.CRANK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.crank")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.DYNAMO.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.dynamo")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.GAS_STATION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.fuel_station")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.GAS_STATION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.fuel_station_admin")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.TANK.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.tank")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.FLUID_EXTRACTOR.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.fluid_extractor")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.BATTERY.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.battery")});
        registration.addIngredientInfo(Arrays.stream(ModItems.CONTAINERS).map(e -> new ItemStack((ItemLike)e.get())).collect(Collectors.toList()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.container")});
        registration.addIngredientInfo(Arrays.stream(ModItems.TANK_CONTAINERS).map(e -> new ItemStack((ItemLike)e.get())).collect(Collectors.toList()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.tank_container")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.LICENSE_PLATE.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.license_plate")});
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"car", (String)"car");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PainterRecipeCategoryYellow(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CarRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

