/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"car");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_STOP = ModSounds.addSound("engine_stop");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_STARTING = ModSounds.addSound("engine_starting");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_START = ModSounds.addSound("engine_start");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_IDLE = ModSounds.addSound("engine_idle");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_HIGH = ModSounds.addSound("engine_high");
    public static DeferredHolder<SoundEvent, SoundEvent> ENGINE_FAIL = ModSounds.addSound("engine_fail");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_STOP = ModSounds.addSound("sport_engine_stop");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_STARTING = ModSounds.addSound("sport_engine_starting");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_START = ModSounds.addSound("sport_engine_start");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_IDLE = ModSounds.addSound("sport_engine_idle");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_HIGH = ModSounds.addSound("sport_engine_high");
    public static DeferredHolder<SoundEvent, SoundEvent> SPORT_ENGINE_FAIL = ModSounds.addSound("sport_engine_fail");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_STOP = ModSounds.addSound("truck_engine_stop");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_STARTING = ModSounds.addSound("truck_engine_starting");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_START = ModSounds.addSound("truck_engine_start");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_IDLE = ModSounds.addSound("truck_engine_idle");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_HIGH = ModSounds.addSound("truck_engine_high");
    public static DeferredHolder<SoundEvent, SoundEvent> TRUCK_ENGINE_FAIL = ModSounds.addSound("truck_engine_fail");
    public static DeferredHolder<SoundEvent, SoundEvent> CAR_CRASH = ModSounds.addSound("car_crash");
    public static DeferredHolder<SoundEvent, SoundEvent> GAS_STATION = ModSounds.addSound("gas_station");
    public static DeferredHolder<SoundEvent, SoundEvent> GENERATOR = ModSounds.addSound("generator");
    public static DeferredHolder<SoundEvent, SoundEvent> CAR_HORN = ModSounds.addSound("car_horn");
    public static DeferredHolder<SoundEvent, SoundEvent> CAR_LOCK = ModSounds.addSound("car_lock");
    public static DeferredHolder<SoundEvent, SoundEvent> CAR_UNLOCK = ModSounds.addSound("car_unlock");
    public static DeferredHolder<SoundEvent, SoundEvent> RATCHET = ModSounds.addSound("ratchet");
    public static DeferredHolder<SoundEvent, SoundEvent> GAS_STATION_ATTENDANT = ModSounds.addSound("gas_station_attendant");

    public static DeferredHolder<SoundEvent, SoundEvent> addSound(String soundName) {
        return SOUND_REGISTER.register(soundName, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"car", (String)soundName)));
    }

    public static void init(IEventBus eventBus) {
        SOUND_REGISTER.register(eventBus);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.playSound(entity, pos, evt, category, volume, pitch);
        } else if (!world.isClientSide) {
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, evt, category, volume, pitch);
        }
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category) {
        ModSounds.playSound(evt, world, pos, entity, category, 0.15f);
    }

    public static boolean isCarSoundCategory(SoundEvent event) {
        if (event == null) {
            return false;
        }
        return event.equals(ENGINE_STOP.get()) || event.equals(ENGINE_STARTING.get()) || event.equals(ENGINE_START.get()) || event.equals(ENGINE_IDLE.get()) || event.equals(ENGINE_HIGH.get()) || event.equals(ENGINE_FAIL.get()) || event.equals(SPORT_ENGINE_STOP.get()) || event.equals(SPORT_ENGINE_STARTING.get()) || event.equals(SPORT_ENGINE_START.get()) || event.equals(SPORT_ENGINE_IDLE.get()) || event.equals(SPORT_ENGINE_HIGH.get()) || event.equals(SPORT_ENGINE_FAIL.get()) || event.equals(TRUCK_ENGINE_STOP.get()) || event.equals(TRUCK_ENGINE_STARTING.get()) || event.equals(TRUCK_ENGINE_START.get()) || event.equals(TRUCK_ENGINE_IDLE.get()) || event.equals(TRUCK_ENGINE_HIGH.get()) || event.equals(TRUCK_ENGINE_FAIL.get()) || event.equals(CAR_CRASH.get()) || event.equals(CAR_HORN.get()) || event.equals(CAR_LOCK.get()) || event.equals(CAR_UNLOCK.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(AbstractTickableSoundInstance loop, Level world) {
        if (world.isClientSide) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)loop);
        }
    }
}

