/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.neoforge.DeferredRegisters;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoForgeBalmEntities
implements BalmEntities {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public <T extends Entity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder) {
        DeferredRegister register = DeferredRegisters.get(Registries.ENTITY_TYPE, identifier.getNamespace());
        DeferredHolder registryObject = register.register(identifier.getPath(), () -> typeBuilder.build(identifier.toString()));
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    @Override
    public <T extends LivingEntity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder, Supplier<AttributeSupplier.Builder> attributeBuilder) {
        DeferredRegister register = DeferredRegisters.get(Registries.ENTITY_TYPE, identifier.getNamespace());
        Registrations registrations = this.getActiveRegistrations();
        DeferredHolder registryObject = register.register(identifier.getPath(), () -> {
            EntityType entityType = typeBuilder.build(identifier.toString());
            registrations.attributeSuppliers.put(entityType, ((AttributeSupplier.Builder)attributeBuilder.get()).build());
            return entityType;
        });
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((DeferredHolder)registryObject).isBound());
    }

    public void register(String modId, IEventBus eventBus) {
        eventBus.register((Object)this.getRegistrations(modId));
    }

    private Registrations getActiveRegistrations() {
        return this.getRegistrations(ModLoadingContext.get().getActiveNamespace());
    }

    private Registrations getRegistrations(String modId) {
        return this.registrations.computeIfAbsent(modId, it -> new Registrations());
    }

    private static class Registrations {
        public final Map<EntityType<?>, AttributeSupplier> attributeSuppliers = new HashMap();

        private Registrations() {
        }

        @SubscribeEvent
        public void registerAttributes(EntityAttributeCreationEvent event) {
            for (Map.Entry<EntityType<?>, AttributeSupplier> entry : this.attributeSuppliers.entrySet()) {
                event.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

