/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.block.IKitchenCabinetry;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class KitchenCabinetryBlock
extends FurnitureHorizontalBlock
implements IKitchenCabinetry {
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);

    public KitchenCabinetryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)((Object)Shape.DEFAULT)));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape topShape = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape baseShape = Block.box((double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);
        VoxelShape baseLeftShape = Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0);
        VoxelShape baseRightShape = Block.box((double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0);
        VoxelShape insideCornerLeftShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)14.0);
        VoxelShape insideCornerRightShape = Block.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)13.0, (double)16.0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.getValue((Property)DIRECTION);
            Shape shape = (Shape)((Object)state.getValue(SHAPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(topShape);
            shapes.add(VoxelShapeHelper.rotateHorizontally(baseShape, direction));
            if (shape != Shape.OUTSIDE_CORNER_LEFT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseLeftShape, direction));
            }
            if (shape != Shape.OUTSIDE_CORNER_RIGHT) {
                shapes.add(VoxelShapeHelper.rotateHorizontally(baseRightShape, direction));
            }
            VoxelShape cornerShape = switch (shape.ordinal()) {
                case 1 -> insideCornerLeftShape;
                case 2 -> insideCornerRightShape;
                default -> Shapes.empty();
            };
            shapes.add(VoxelShapeHelper.rotateHorizontally(cornerShape, direction));
            builder.put((Object)state, (Object)VoxelShapeHelper.combine(shapes));
        }
        return builder.build();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (LevelAccessor)context.getLevel(), context.getClickedPos()))) : null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, level, pos)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHAPE});
    }

    public Shape getShape(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction behind;
        Direction facing = (Direction)state.getValue((Property)DIRECTION);
        Direction front = this.getCabinetryDirection(level, pos, ((Direction)state.getValue((Property)DIRECTION)).getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return Shape.INSIDE_CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return Shape.INSIDE_CORNER_LEFT;
            }
        }
        if ((behind = this.getCabinetryDirection(level, pos, (Direction)state.getValue((Property)DIRECTION))) != null) {
            if (behind == facing.getClockWise()) {
                return Shape.OUTSIDE_CORNER_LEFT;
            }
            if (behind == facing.getCounterClockWise()) {
                return Shape.OUTSIDE_CORNER_RIGHT;
            }
        }
        return Shape.DEFAULT;
    }

    public Direction getCabinetryDirection(LevelAccessor level, BlockPos pos, Direction side) {
        Direction direction;
        BlockState relativeState = level.getBlockState(pos.relative(side));
        Block block = relativeState.getBlock();
        if (block instanceof IKitchenCabinetry) {
            IKitchenCabinetry cabinetry = (IKitchenCabinetry)block;
            direction = cabinetry.getDirection(relativeState);
        } else {
            direction = null;
        }
        return direction;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.getValue((Property)DIRECTION);
    }

    public static enum Shape implements StringRepresentable
    {
        DEFAULT("default"),
        INSIDE_CORNER_LEFT("inside_corner_left"),
        INSIDE_CORNER_RIGHT("inside_corner_right"),
        OUTSIDE_CORNER_LEFT("outside_corner_left"),
        OUTSIDE_CORNER_RIGHT("outside_corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

