/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.placement;

import biomesoplenty.util.worldgen.BOPPlacementUtils;
import biomesoplenty.worldgen.feature.BOPEndFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class BOPEndPlacements {
    public static final ResourceKey<PlacedFeature> ANOMALY = BOPPlacementUtils.createKey("anomaly");
    public static final ResourceKey<PlacedFeature> BARNACLES = BOPPlacementUtils.createKey("barnacles");
    public static final ResourceKey<PlacedFeature> DEAD_CORAL = BOPPlacementUtils.createKey("dead_coral");
    public static final ResourceKey<PlacedFeature> DEAD_CORAL_PATCH = BOPPlacementUtils.createKey("dead_coral_patch");
    public static final ResourceKey<PlacedFeature> ENDERPHYTE_BONEMEAL = BOPPlacementUtils.createKey("enderphyte_bonemeal");
    public static final ResourceKey<PlacedFeature> FLOWER_END_WILDS = BOPPlacementUtils.createKey("flower_end_wilds");
    public static final ResourceKey<PlacedFeature> JAGGED_SANDSTONE = BOPPlacementUtils.createKey("jagged_sandstone");
    public static final ResourceKey<PlacedFeature> LIQUID_NULL_LAKE = BOPPlacementUtils.createKey("liquid_null_lake");
    public static final ResourceKey<PlacedFeature> LIQUID_NULL_SPRING = BOPPlacementUtils.createKey("liquid_null_spring");
    public static final ResourceKey<PlacedFeature> LUMALOOP = BOPPlacementUtils.createKey("lumaloop");
    public static final ResourceKey<PlacedFeature> MONOLITH = BOPPlacementUtils.createKey("monolith");
    public static final ResourceKey<PlacedFeature> NULL_PLANT_BONEMEAL = BOPPlacementUtils.createKey("null_plant_bonemeal");
    public static final ResourceKey<PlacedFeature> PATCH_ENDERPHYTES = BOPPlacementUtils.createKey("patch_enderphytes");
    public static final ResourceKey<PlacedFeature> PATCH_NULL_PLANTS = BOPPlacementUtils.createKey("patch_null_plants");
    public static final ResourceKey<PlacedFeature> TIDEPOOL = BOPPlacementUtils.createKey("tidepool");
    public static final ResourceKey<PlacedFeature> TREES_END_CORRUPTION = BOPPlacementUtils.createKey("trees_end_corruption");
    public static final ResourceKey<PlacedFeature> TREES_END_WILDS = BOPPlacementUtils.createKey("trees_end_wilds");
    public static final ResourceKey<PlacedFeature> WISPJELLY = BOPPlacementUtils.createKey("wispjelly");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference ANOMALY = configuredFeatureGetter.getOrThrow(BOPEndFeatures.ANOMALY);
        Holder.Reference BARNACLES = configuredFeatureGetter.getOrThrow(BOPEndFeatures.BARNACLES);
        Holder.Reference DEAD_CORAL = configuredFeatureGetter.getOrThrow(BOPEndFeatures.DEAD_CORAL);
        Holder.Reference DEAD_CORAL_PATCH = configuredFeatureGetter.getOrThrow(BOPEndFeatures.DEAD_CORAL_PATCH);
        Holder.Reference ENDERPHYTE_BONEMEAL = configuredFeatureGetter.getOrThrow(BOPEndFeatures.ENDERPHYTE_BONEMEAL);
        Holder.Reference FLOWER_END_WILDS = configuredFeatureGetter.getOrThrow(BOPEndFeatures.FLOWER_END_WILDS);
        Holder.Reference JAGGED_SANDSTONE = configuredFeatureGetter.getOrThrow(BOPEndFeatures.JAGGED_SANDSTONE);
        Holder.Reference LIQUID_NULL_LAKE = configuredFeatureGetter.getOrThrow(BOPEndFeatures.LIQUID_NULL_LAKE);
        Holder.Reference LIQUID_NULL_SPRING = configuredFeatureGetter.getOrThrow(BOPEndFeatures.LIQUID_NULL_SPRING);
        Holder.Reference LUMALOOP = configuredFeatureGetter.getOrThrow(BOPEndFeatures.LUMALOOP);
        Holder.Reference MONOLITH = configuredFeatureGetter.getOrThrow(BOPEndFeatures.MONOLITH);
        Holder.Reference NULL_PLANT_BONEMEAL = configuredFeatureGetter.getOrThrow(BOPEndFeatures.NULL_PLANT_BONEMEAL);
        Holder.Reference PATCH_ENDERPHYTES = configuredFeatureGetter.getOrThrow(BOPEndFeatures.PATCH_ENDERPHYTES);
        Holder.Reference PATCH_NULL_PLANTS = configuredFeatureGetter.getOrThrow(BOPEndFeatures.PATCH_NULL_PLANTS);
        Holder.Reference TIDEPOOL = configuredFeatureGetter.getOrThrow(BOPEndFeatures.TIDEPOOL);
        Holder.Reference TREES_END_CORRUPTION = configuredFeatureGetter.getOrThrow(BOPEndFeatures.TREES_END_CORRUPTION);
        Holder.Reference TREES_END_WILDS = configuredFeatureGetter.getOrThrow(BOPEndFeatures.TREES_END_WILDS);
        Holder.Reference WISPJELLY = configuredFeatureGetter.getOrThrow(BOPEndFeatures.WISPJELLY);
        BOPEndPlacements.register(context, BOPEndPlacements.ANOMALY, ANOMALY, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.BARNACLES, BARNACLES, List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.DEAD_CORAL, DEAD_CORAL, List.of(CountPlacement.of((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.DEAD_CORAL_PATCH, DEAD_CORAL_PATCH, List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.ENDERPHYTE_BONEMEAL, ENDERPHYTE_BONEMEAL, new PlacementModifier[]{PlacementUtils.isEmpty()});
        BOPEndPlacements.register(context, BOPEndPlacements.FLOWER_END_WILDS, FLOWER_END_WILDS, List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.JAGGED_SANDSTONE, JAGGED_SANDSTONE, List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.LIQUID_NULL_LAKE, LIQUID_NULL_LAKE, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.LIQUID_NULL_SPRING, LIQUID_NULL_SPRING, List.of(CountPlacement.of((int)10), InSquarePlacement.spread(), PlacementUtils.FULL_RANGE, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.LUMALOOP, LUMALOOP, List.of(RarityFilter.onAverageOnceEvery((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.MONOLITH, MONOLITH, List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.NULL_PLANT_BONEMEAL, NULL_PLANT_BONEMEAL, new PlacementModifier[]{PlacementUtils.isEmpty()});
        BOPEndPlacements.register(context, BOPEndPlacements.PATCH_ENDERPHYTES, PATCH_ENDERPHYTES, VegetationPlacements.worldSurfaceSquaredWithCount((int)5));
        BOPEndPlacements.register(context, BOPEndPlacements.PATCH_NULL_PLANTS, PATCH_NULL_PLANTS, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.TIDEPOOL, TIDEPOOL, List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        BOPEndPlacements.register(context, BOPEndPlacements.TREES_END_CORRUPTION, TREES_END_CORRUPTION, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)0, (float)0.2f, (int)1)));
        BOPEndPlacements.register(context, BOPEndPlacements.TREES_END_WILDS, TREES_END_WILDS, VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)1, (float)0.1f, (int)1)));
        BOPEndPlacements.register(context, BOPEndPlacements.WISPJELLY, WISPJELLY, List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> placedFeatureKey, Holder<ConfiguredFeature<?, ?>> configuredFeature, PlacementModifier ... modifiers) {
        BOPEndPlacements.register(context, placedFeatureKey, configuredFeature, List.of(modifiers));
    }

    protected static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> placedFeatureKey, Holder<ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> modifiers) {
        context.register(placedFeatureKey, (Object)new PlacedFeature(configuredFeature, modifiers));
    }
}

